/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.org.apache.curator.framework.recipes.queue;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.flink.shaded.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.org.apache.curator.framework.listen.ListenerContainer;
import org.apache.flink.shaded.org.apache.curator.framework.recipes.queue.DistributedQueue;
import org.apache.flink.shaded.org.apache.curator.framework.recipes.queue.ErrorMode;
import org.apache.flink.shaded.org.apache.curator.framework.recipes.queue.QueueBase;
import org.apache.flink.shaded.org.apache.curator.framework.recipes.queue.QueueConsumer;
import org.apache.flink.shaded.org.apache.curator.framework.recipes.queue.QueuePutListener;
import org.apache.flink.shaded.org.apache.curator.framework.recipes.queue.QueueSerializer;
import org.apache.flink.shaded.org.apache.curator.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedIdQueue<T>
implements QueueBase<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DistributedQueue<T> queue;
    private static final char SEPARATOR = '|';

    DistributedIdQueue(CuratorFramework client, QueueConsumer<T> consumer, QueueSerializer<T> serializer, String queuePath, ThreadFactory threadFactory, Executor executor, int minItemsBeforeRefresh, boolean refreshOnWatch, String lockPath, int maxItems, boolean putInBackground, int finalFlushMs) {
        this.queue = new DistributedQueue<T>(client, consumer, serializer, queuePath, threadFactory, executor, minItemsBeforeRefresh, refreshOnWatch, lockPath, maxItems, putInBackground, finalFlushMs){

            @Override
            protected void sortChildren(List<String> children) {
                DistributedIdQueue.this.internalSortChildren(children);
            }

            @Override
            protected String makeRequeueItemPath(String itemPath) {
                return DistributedIdQueue.this.makeIdPath(((DistributedIdQueue)DistributedIdQueue.this).parseId((String)itemPath).id);
            }
        };
        if (this.queue.makeItemPath().contains(Character.toString('|'))) {
            throw new IllegalStateException("DistributedQueue can't use |");
        }
    }

    @Override
    public void start() throws Exception {
        this.queue.start();
    }

    @Override
    public void close() throws IOException {
        this.queue.close();
    }

    @Override
    public ListenerContainer<QueuePutListener<T>> getPutListenerContainer() {
        return this.queue.getPutListenerContainer();
    }

    @Override
    public void setErrorMode(ErrorMode newErrorMode) {
        this.queue.setErrorMode(newErrorMode);
    }

    @Override
    public boolean flushPuts(long waitTime, TimeUnit timeUnit) throws InterruptedException {
        return this.queue.flushPuts(waitTime, timeUnit);
    }

    @Override
    public int getLastMessageCount() {
        return this.queue.getLastMessageCount();
    }

    public void put(T item, String itemId) throws Exception {
        this.put(item, itemId, 0, null);
    }

    public boolean put(T item, String itemId, int maxWait, TimeUnit unit) throws Exception {
        Preconditions.checkArgument(this.isValidId(itemId), "Invalid id: " + itemId);
        this.queue.checkState();
        return this.queue.internalPut(item, null, this.makeIdPath(itemId), maxWait, unit);
    }

    public int remove(String id) throws Exception {
        id = Preconditions.checkNotNull(id, "id cannot be null");
        this.queue.checkState();
        int count = 0;
        for (String name : this.queue.getChildren()) {
            if (!this.parseId((String)name).id.equals(id) || !this.queue.tryRemove(name)) continue;
            ++count;
        }
        return count;
    }

    @VisibleForTesting
    boolean debugIsQueued(String id) throws Exception {
        for (String name : this.queue.getChildren()) {
            if (!this.parseId((String)name).id.equals(id)) continue;
            return true;
        }
        return false;
    }

    private String makeIdPath(String itemId) {
        return this.queue.makeItemPath() + '|' + DistributedIdQueue.fixId(itemId) + '|';
    }

    private void internalSortChildren(List<String> children) {
        Collections.sort(children, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return ((DistributedIdQueue)DistributedIdQueue.this).parseId((String)o1).cleaned.compareTo(((DistributedIdQueue)DistributedIdQueue.this).parseId((String)o2).cleaned);
            }
        });
    }

    private boolean isValidId(String id) {
        return id != null && id.length() > 0;
    }

    private static String fixId(String id) {
        String fixed = id.replace('/', '_');
        return fixed.replace('|', '_');
    }

    private Parts parseId(String name) {
        int firstIndex = name.indexOf(124);
        int secondIndex = name.indexOf(124, firstIndex + 1);
        if (firstIndex < 0 || secondIndex < 0) {
            this.log.error("Bad node in queue: " + name);
            return new Parts(name, name);
        }
        return new Parts(name.substring(firstIndex + 1, secondIndex), name.substring(0, firstIndex) + name.substring(secondIndex + 1));
    }

    private static class Parts {
        final String id;
        final String cleaned;

        private Parts(String id, String cleaned) {
            this.id = id;
            this.cleaned = cleaned;
        }
    }
}

