/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.rpc;

import java.util.UUID;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.ApplyFunction;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.io.network.partition.ResultPartitionConsumableNotifier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.taskmanager.TaskActions;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcResultPartitionConsumableNotifier
implements ResultPartitionConsumableNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(RpcResultPartitionConsumableNotifier.class);
    private final UUID jobMasterLeaderId;
    private final JobMasterGateway jobMasterGateway;
    private final Executor executor;
    private final Time timeout;

    public RpcResultPartitionConsumableNotifier(UUID jobMasterLeaderId, JobMasterGateway jobMasterGateway, Executor executor, Time timeout) {
        this.jobMasterLeaderId = (UUID)Preconditions.checkNotNull((Object)jobMasterLeaderId);
        this.jobMasterGateway = (JobMasterGateway)Preconditions.checkNotNull((Object)jobMasterGateway);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.timeout = (Time)Preconditions.checkNotNull((Object)timeout);
    }

    @Override
    public void notifyPartitionConsumable(JobID jobId, ResultPartitionID partitionId, final TaskActions taskActions) {
        Future<Acknowledge> acknowledgeFuture = this.jobMasterGateway.scheduleOrUpdateConsumers(this.jobMasterLeaderId, partitionId, this.timeout);
        acknowledgeFuture.exceptionallyAsync(new ApplyFunction<Throwable, Void>(){

            @Override
            public Void apply(Throwable value) {
                LOG.error("Could not schedule or update consumers at the JobManager.", value);
                taskActions.failExternally(new RuntimeException("Could not notify JobManager to schedule or update consumers.", value));
                return null;
            }
        }, this.executor);
    }
}

