/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.core.io.VersionedIOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.OperatorBackendStateMetaInfoSnapshotReaderWriters;
import org.apache.flink.runtime.state.RegisteredOperatorBackendStateMetaInfo;
import org.apache.flink.util.Preconditions;

public class OperatorBackendSerializationProxy
extends VersionedIOReadableWritable {
    public static final int VERSION = 2;
    private List<RegisteredOperatorBackendStateMetaInfo.Snapshot<?>> stateMetaInfoSnapshots;
    private ClassLoader userCodeClassLoader;

    public OperatorBackendSerializationProxy(ClassLoader userCodeClassLoader) {
        this.userCodeClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userCodeClassLoader);
    }

    public OperatorBackendSerializationProxy(List<RegisteredOperatorBackendStateMetaInfo.Snapshot<?>> stateMetaInfoSnapshots) {
        this.stateMetaInfoSnapshots = (List)Preconditions.checkNotNull(stateMetaInfoSnapshots);
        Preconditions.checkArgument((stateMetaInfoSnapshots.size() <= Short.MAX_VALUE ? 1 : 0) != 0);
    }

    public int getVersion() {
        return 2;
    }

    public int[] getCompatibleVersions() {
        return new int[]{2, 1};
    }

    public void write(DataOutputView out) throws IOException {
        super.write(out);
        out.writeShort(this.stateMetaInfoSnapshots.size());
        for (RegisteredOperatorBackendStateMetaInfo.Snapshot<?> kvState : this.stateMetaInfoSnapshots) {
            OperatorBackendStateMetaInfoSnapshotReaderWriters.getWriterForVersion(2, kvState).writeStateMetaInfo(out);
        }
    }

    public void read(DataInputView in) throws IOException {
        super.read(in);
        int numKvStates = in.readShort();
        this.stateMetaInfoSnapshots = new ArrayList(numKvStates);
        for (int i = 0; i < numKvStates; ++i) {
            this.stateMetaInfoSnapshots.add(OperatorBackendStateMetaInfoSnapshotReaderWriters.getReaderForVersion(this.getReadVersion(), this.userCodeClassLoader).readStateMetaInfo(in));
        }
    }

    public List<RegisteredOperatorBackendStateMetaInfo.Snapshot<?>> getStateMetaInfoSnapshots() {
        return this.stateMetaInfoSnapshots;
    }
}

