/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.List;
import org.apache.flink.runtime.concurrent.BiFunction;
import org.apache.flink.runtime.concurrent.Future;
import org.apache.flink.runtime.executiongraph.ExecutionAndSlot;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.util.ExceptionUtils;

public class ExecutionGraphUtils {
    public static void releaseSlotFuture(Future<SimpleSlot> slotFuture) {
        slotFuture.handle(ReleaseSlotFunction.INSTANCE);
    }

    public static void releaseAllSlotsSilently(List<ExecutionAndSlot[]> resources) {
        try {
            for (ExecutionAndSlot[] jobVertexResources : resources) {
                if (jobVertexResources == null) continue;
                for (ExecutionAndSlot execAndSlot : jobVertexResources) {
                    if (execAndSlot == null) continue;
                    try {
                        ExecutionGraphUtils.releaseSlotFuture(execAndSlot.slotFuture);
                    }
                    catch (Throwable t) {
                        ExceptionUtils.rethrowIfFatalError((Throwable)t);
                    }
                }
            }
        }
        catch (Throwable t) {
            ExceptionUtils.rethrowIfFatalError((Throwable)t);
        }
    }

    private ExecutionGraphUtils() {
    }

    private static final class ReleaseSlotFunction
    implements BiFunction<SimpleSlot, Throwable, Void> {
        static final ReleaseSlotFunction INSTANCE = new ReleaseSlotFunction();

        private ReleaseSlotFunction() {
        }

        @Override
        public Void apply(SimpleSlot simpleSlot, Throwable throwable) {
            if (simpleSlot != null) {
                simpleSlot.releaseSlot();
            }
            return null;
        }
    }
}

