/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingSlotRequest;
import org.apache.flink.util.Preconditions;

public class TaskManagerSlot {
    private final SlotID slotId;
    private final ResourceProfile resourceProfile;
    private final TaskExecutorConnection taskManagerConnection;
    private AllocationID allocationId;
    private PendingSlotRequest assignedSlotRequest;

    public TaskManagerSlot(SlotID slotId, ResourceProfile resourceProfile, TaskExecutorConnection taskManagerConnection, AllocationID allocationId) {
        this.slotId = (SlotID)Preconditions.checkNotNull((Object)slotId);
        this.resourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)resourceProfile);
        this.taskManagerConnection = (TaskExecutorConnection)Preconditions.checkNotNull((Object)taskManagerConnection);
        this.allocationId = allocationId;
        this.assignedSlotRequest = null;
    }

    public SlotID getSlotId() {
        return this.slotId;
    }

    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    public TaskExecutorConnection getTaskManagerConnection() {
        return this.taskManagerConnection;
    }

    public AllocationID getAllocationId() {
        return this.allocationId;
    }

    public void setAllocationId(AllocationID allocationId) {
        this.allocationId = allocationId;
    }

    public PendingSlotRequest getAssignedSlotRequest() {
        return this.assignedSlotRequest;
    }

    public void setAssignedSlotRequest(PendingSlotRequest assignedSlotRequest) {
        this.assignedSlotRequest = assignedSlotRequest;
    }

    public InstanceID getInstanceId() {
        return this.taskManagerConnection.getInstanceID();
    }

    public boolean isMatchingRequirement(ResourceProfile required) {
        return this.resourceProfile.isMatching(required);
    }

    public boolean isFree() {
        return !this.isAllocated() && !this.hasPendingSlotRequest();
    }

    public boolean isAllocated() {
        return null != this.allocationId;
    }

    public boolean hasPendingSlotRequest() {
        return null != this.assignedSlotRequest;
    }
}

