/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.watermark;

import java.util.BitSet;
import java.util.function.Consumer;
import org.apache.flink.api.common.watermark.BoolWatermark;
import org.apache.flink.api.common.watermark.Watermark;
import org.apache.flink.api.common.watermark.WatermarkCombinationFunction;
import org.apache.flink.api.common.watermark.WatermarkCombinationPolicy;
import org.apache.flink.streaming.runtime.watermark.WatermarkCombiner;
import org.apache.flink.util.Preconditions;

public class BoolWatermarkCombiner
implements WatermarkCombiner {
    private final WatermarkCombinationPolicy combinationPolicy;
    private final int numberOfInputChannels;
    private final BitSet hasReceiveWatermarks;
    private final BitSet watermarkValues;
    private boolean previousEmitWatermarkValue = false;
    private boolean isFirstTimeEmit = true;

    public BoolWatermarkCombiner(WatermarkCombinationPolicy combinationPolicy, int numberOfInputChannels) {
        Preconditions.checkState((boolean)(combinationPolicy.getWatermarkCombinationFunction() instanceof WatermarkCombinationFunction.BoolWatermarkCombinationFunction));
        this.combinationPolicy = combinationPolicy;
        this.numberOfInputChannels = numberOfInputChannels;
        this.hasReceiveWatermarks = new BitSet(numberOfInputChannels);
        this.watermarkValues = new BitSet(numberOfInputChannels);
        if (combinationPolicy.getWatermarkCombinationFunction() == WatermarkCombinationFunction.BoolWatermarkCombinationFunction.OR) {
            this.watermarkValues.clear(0, numberOfInputChannels);
        } else if (combinationPolicy.getWatermarkCombinationFunction() == WatermarkCombinationFunction.BoolWatermarkCombinationFunction.AND) {
            this.watermarkValues.set(0, numberOfInputChannels);
        } else {
            throw new IllegalArgumentException("Illegal WatermarkCombinationFunction for BoolWatermarkCombiner: " + String.valueOf(combinationPolicy.getWatermarkCombinationFunction()));
        }
    }

    @Override
    public void combineWatermark(Watermark watermark, int channelIndex, Consumer<Watermark> watermarkEmitter) throws Exception {
        boolean combinedWatermarkValue;
        Preconditions.checkState((boolean)(watermark instanceof BoolWatermark));
        this.hasReceiveWatermarks.set(channelIndex);
        this.watermarkValues.set(channelIndex, ((BoolWatermark)watermark).getValue());
        if (this.combinationPolicy.isCombineWaitForAllChannels() && this.hasReceiveWatermarks.cardinality() < this.numberOfInputChannels) {
            return;
        }
        if (this.combinationPolicy.getWatermarkCombinationFunction() == WatermarkCombinationFunction.BoolWatermarkCombinationFunction.OR) {
            combinedWatermarkValue = this.watermarkValues.cardinality() > 0;
        } else {
            boolean bl = combinedWatermarkValue = this.watermarkValues.cardinality() == this.numberOfInputChannels;
        }
        if (this.shouldEmitWatermark(combinedWatermarkValue)) {
            watermarkEmitter.accept((Watermark)new BoolWatermark(combinedWatermarkValue, watermark.getIdentifier()));
            this.previousEmitWatermarkValue = combinedWatermarkValue;
        }
    }

    private boolean shouldEmitWatermark(boolean combinedWatermarkValue) {
        if (this.isFirstTimeEmit) {
            this.isFirstTimeEmit = false;
            return true;
        }
        return combinedWatermarkValue != this.previousEmitWatermarkValue;
    }
}

