/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.time.Duration;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.state.AppendingState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.v2.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.v2.ListStateDescriptor;
import org.apache.flink.api.common.state.v2.StateIterator;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.asyncprocessing.operators.windowing.AsyncEvictingWindowOperator;
import org.apache.flink.runtime.asyncprocessing.operators.windowing.AsyncWindowOperator;
import org.apache.flink.runtime.asyncprocessing.operators.windowing.functions.InternalAggregateProcessAsyncWindowFunction;
import org.apache.flink.runtime.asyncprocessing.operators.windowing.functions.InternalAsyncWindowFunction;
import org.apache.flink.runtime.asyncprocessing.operators.windowing.functions.InternalIterableAsyncWindowFunction;
import org.apache.flink.runtime.asyncprocessing.operators.windowing.functions.InternalIterableProcessAsyncWindowFunction;
import org.apache.flink.runtime.asyncprocessing.operators.windowing.functions.InternalSingleValueAsyncWindowFunction;
import org.apache.flink.runtime.asyncprocessing.operators.windowing.functions.InternalSingleValueProcessAsyncWindowFunction;
import org.apache.flink.runtime.asyncprocessing.operators.windowing.triggers.AsyncTrigger;
import org.apache.flink.streaming.api.functions.windowing.AggregateApplyWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.ProcessWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.ReduceApplyProcessWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.ReduceApplyWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.WindowFunction;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.windowing.assigners.MergingWindowAssigner;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.AsyncTriggerConverter;
import org.apache.flink.streaming.runtime.operators.windowing.EvictingWindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.WindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalAggregateProcessWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalIterableProcessWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalIterableWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalSingleValueProcessWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalSingleValueWindowFunction;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalWindowFunction;
import org.apache.flink.streaming.runtime.streamrecord.StreamElementSerializer;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

public class WindowOperatorBuilder<T, K, W extends Window> {
    private static final String WINDOW_STATE_NAME = "window-contents";
    private final ExecutionConfig config;
    private final WindowAssigner<? super T, W> windowAssigner;
    private final TypeInformation<T> inputType;
    private final KeySelector<T, K> keySelector;
    private final TypeInformation<K> keyType;
    private Trigger<? super T, ? super W> trigger;
    private AsyncTrigger<? super T, ? super W> asyncTrigger;
    @Nullable
    private Evictor<? super T, ? super W> evictor;
    private long allowedLateness = 0L;
    @Nullable
    private OutputTag<T> lateDataOutputTag;

    public WindowOperatorBuilder(WindowAssigner<? super T, W> windowAssigner, Trigger<? super T, ? super W> trigger, ExecutionConfig config, TypeInformation<T> inputType, KeySelector<T, K> keySelector, TypeInformation<K> keyType) {
        this.windowAssigner = windowAssigner;
        this.config = config;
        this.inputType = inputType;
        this.keySelector = keySelector;
        this.keyType = keyType;
        this.trigger = trigger;
    }

    public void trigger(Trigger<? super T, ? super W> trigger) {
        Preconditions.checkNotNull(trigger, (String)"Window triggers cannot be null");
        if (this.windowAssigner instanceof MergingWindowAssigner && !trigger.canMerge()) {
            throw new UnsupportedOperationException("A merging window assigner cannot be used with a trigger that does not support merging.");
        }
        this.trigger = trigger;
    }

    public WindowOperatorBuilder<T, K, W> asyncTrigger(AsyncTrigger<? super T, ? super W> asyncTrigger) {
        Preconditions.checkNotNull(asyncTrigger, (String)"AsyncTrigger cannot be null");
        if (this.windowAssigner instanceof MergingWindowAssigner && !asyncTrigger.canMerge()) {
            throw new UnsupportedOperationException("A merging window assigner cannot be used with a trigger that does not support merging.");
        }
        this.asyncTrigger = asyncTrigger;
        return this;
    }

    public void allowedLateness(Duration lateness) {
        Preconditions.checkNotNull((Object)lateness, (String)"Allowed lateness cannot be null");
        long millis = lateness.toMillis();
        Preconditions.checkArgument((millis >= 0L ? 1 : 0) != 0, (Object)"The allowed lateness cannot be negative.");
        this.allowedLateness = millis;
    }

    public void sideOutputLateData(OutputTag<T> outputTag) {
        Preconditions.checkNotNull(outputTag, (String)"Side output tag must not be null.");
        this.lateDataOutputTag = outputTag;
    }

    public void evictor(Evictor<? super T, ? super W> evictor) {
        Preconditions.checkNotNull(evictor, (String)"Evictor cannot be null");
        this.evictor = evictor;
    }

    public <R> OneInputStreamOperator<T, R> reduce(ReduceFunction<T> reduceFunction, WindowFunction<T, R, K, W> function) {
        Preconditions.checkNotNull(reduceFunction, (String)"ReduceFunction cannot be null");
        Preconditions.checkNotNull(function, (String)"WindowFunction cannot be null");
        if (reduceFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("ReduceFunction of apply can not be a RichFunction.");
        }
        if (this.evictor != null) {
            return this.buildEvictingWindowOperator(new InternalIterableWindowFunction<K, W, T, R>(new ReduceApplyWindowFunction<K, W, T, R>(reduceFunction, function)));
        }
        ReducingStateDescriptor stateDesc = new ReducingStateDescriptor(WINDOW_STATE_NAME, reduceFunction, this.inputType.createSerializer(this.config.getSerializerConfig()));
        return this.buildWindowOperator((StateDescriptor)stateDesc, (InternalWindowFunction)new InternalSingleValueWindowFunction<T, R, K, W>(function));
    }

    public <R> OneInputStreamOperator<T, R> asyncReduce(ReduceFunction<T> reduceFunction, WindowFunction<T, R, K, W> function) {
        Preconditions.checkNotNull(reduceFunction, (String)"ReduceFunction cannot be null");
        Preconditions.checkNotNull(function, (String)"WindowFunction cannot be null");
        if (reduceFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("ReduceFunction of apply can not be a RichFunction.");
        }
        if (this.evictor != null) {
            return this.buildAsyncEvictingWindowOperator(new InternalIterableAsyncWindowFunction<K, W, T, R>(new ReduceApplyWindowFunction<K, W, T, R>(reduceFunction, function)));
        }
        org.apache.flink.api.common.state.v2.ReducingStateDescriptor stateDesc = new org.apache.flink.api.common.state.v2.ReducingStateDescriptor(WINDOW_STATE_NAME, reduceFunction, this.inputType.createSerializer(this.config.getSerializerConfig()));
        return this.buildAsyncWindowOperator((org.apache.flink.api.common.state.v2.StateDescriptor<?>)stateDesc, (InternalAsyncWindowFunction)new InternalSingleValueAsyncWindowFunction<T, R, K, W>(function));
    }

    public <R> OneInputStreamOperator<T, R> reduce(ReduceFunction<T> reduceFunction, ProcessWindowFunction<T, R, K, W> function) {
        Preconditions.checkNotNull(reduceFunction, (String)"ReduceFunction cannot be null");
        Preconditions.checkNotNull(function, (String)"ProcessWindowFunction cannot be null");
        if (reduceFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("ReduceFunction of apply can not be a RichFunction.");
        }
        if (this.evictor != null) {
            return this.buildEvictingWindowOperator(new InternalIterableProcessWindowFunction<K, W, T, R>(new ReduceApplyProcessWindowFunction<K, W, T, R>(reduceFunction, function)));
        }
        ReducingStateDescriptor stateDesc = new ReducingStateDescriptor(WINDOW_STATE_NAME, reduceFunction, this.inputType.createSerializer(this.config.getSerializerConfig()));
        return this.buildWindowOperator((StateDescriptor)stateDesc, (InternalWindowFunction)new InternalSingleValueProcessWindowFunction<T, R, K, W>(function));
    }

    public <R> OneInputStreamOperator<T, R> asyncReduce(ReduceFunction<T> reduceFunction, ProcessWindowFunction<T, R, K, W> function) {
        Preconditions.checkNotNull(reduceFunction, (String)"ReduceFunction cannot be null");
        Preconditions.checkNotNull(function, (String)"ProcessWindowFunction cannot be null");
        if (reduceFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("ReduceFunction of apply can not be a RichFunction.");
        }
        if (this.evictor != null) {
            return this.buildAsyncEvictingWindowOperator(new InternalIterableProcessAsyncWindowFunction<K, W, T, R>(new ReduceApplyProcessWindowFunction<K, W, T, R>(reduceFunction, function)));
        }
        org.apache.flink.api.common.state.v2.ReducingStateDescriptor stateDesc = new org.apache.flink.api.common.state.v2.ReducingStateDescriptor(WINDOW_STATE_NAME, reduceFunction, this.inputType.createSerializer(this.config.getSerializerConfig()));
        return this.buildAsyncWindowOperator((org.apache.flink.api.common.state.v2.StateDescriptor<?>)stateDesc, (InternalAsyncWindowFunction)new InternalSingleValueProcessAsyncWindowFunction<T, R, K, W>(function));
    }

    public <ACC, V, R> OneInputStreamOperator<T, R> aggregate(AggregateFunction<T, ACC, V> aggregateFunction, WindowFunction<V, R, K, W> windowFunction, TypeInformation<ACC> accumulatorType) {
        Preconditions.checkNotNull(aggregateFunction, (String)"AggregateFunction cannot be null");
        Preconditions.checkNotNull(windowFunction, (String)"WindowFunction cannot be null");
        if (aggregateFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("This aggregate function cannot be a RichFunction.");
        }
        if (this.evictor != null) {
            return this.buildEvictingWindowOperator(new InternalIterableWindowFunction(new AggregateApplyWindowFunction<K, W, T, ACC, V, R>(aggregateFunction, windowFunction)));
        }
        org.apache.flink.api.common.state.AggregatingStateDescriptor stateDesc = new org.apache.flink.api.common.state.AggregatingStateDescriptor(WINDOW_STATE_NAME, aggregateFunction, accumulatorType.createSerializer(this.config.getSerializerConfig()));
        return this.buildWindowOperator((StateDescriptor<? extends AppendingState<T, ACC>, ?>)stateDesc, (InternalWindowFunction<ACC, R, K, W>)new InternalSingleValueWindowFunction<V, R, K, W>(windowFunction));
    }

    public <ACC, V, R> OneInputStreamOperator<T, R> asyncAggregate(AggregateFunction<T, ACC, V> aggregateFunction, WindowFunction<V, R, K, W> windowFunction, TypeInformation<ACC> accumulatorType) {
        Preconditions.checkNotNull(aggregateFunction, (String)"AggregateFunction cannot be null");
        Preconditions.checkNotNull(windowFunction, (String)"WindowFunction cannot be null");
        if (aggregateFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("This aggregate function cannot be a RichFunction.");
        }
        if (this.evictor != null) {
            return this.buildAsyncEvictingWindowOperator(new InternalIterableAsyncWindowFunction(new AggregateApplyWindowFunction<K, W, T, ACC, V, R>(aggregateFunction, windowFunction)));
        }
        AggregatingStateDescriptor stateDesc = new AggregatingStateDescriptor(WINDOW_STATE_NAME, aggregateFunction, accumulatorType.createSerializer(this.config.getSerializerConfig()));
        return this.buildAsyncWindowOperator((org.apache.flink.api.common.state.v2.StateDescriptor<?>)stateDesc, (InternalAsyncWindowFunction<ACC, R, K, W>)new InternalSingleValueAsyncWindowFunction<V, R, K, W>(windowFunction));
    }

    public <ACC, V, R> OneInputStreamOperator<T, R> aggregate(AggregateFunction<T, ACC, V> aggregateFunction, ProcessWindowFunction<V, R, K, W> windowFunction, TypeInformation<ACC> accumulatorType) {
        Preconditions.checkNotNull(aggregateFunction, (String)"AggregateFunction cannot be null");
        Preconditions.checkNotNull(windowFunction, (String)"ProcessWindowFunction cannot be null");
        if (aggregateFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("This aggregate function cannot be a RichFunction.");
        }
        if (this.evictor != null) {
            return this.buildEvictingWindowOperator(new InternalAggregateProcessWindowFunction<T, ACC, V, R, K, W>(aggregateFunction, windowFunction));
        }
        org.apache.flink.api.common.state.AggregatingStateDescriptor stateDesc = new org.apache.flink.api.common.state.AggregatingStateDescriptor(WINDOW_STATE_NAME, aggregateFunction, accumulatorType.createSerializer(this.config.getSerializerConfig()));
        return this.buildWindowOperator((StateDescriptor<? extends AppendingState<T, ACC>, ?>)stateDesc, (InternalWindowFunction<ACC, R, K, W>)new InternalSingleValueProcessWindowFunction<V, R, K, W>(windowFunction));
    }

    public <ACC, V, R> OneInputStreamOperator<T, R> asyncAggregate(AggregateFunction<T, ACC, V> aggregateFunction, ProcessWindowFunction<V, R, K, W> windowFunction, TypeInformation<ACC> accumulatorType) {
        Preconditions.checkNotNull(aggregateFunction, (String)"AggregateFunction cannot be null");
        Preconditions.checkNotNull(windowFunction, (String)"ProcessWindowFunction cannot be null");
        if (aggregateFunction instanceof RichFunction) {
            throw new UnsupportedOperationException("This aggregate function cannot be a RichFunction.");
        }
        if (this.evictor != null) {
            return this.buildAsyncEvictingWindowOperator(new InternalAggregateProcessAsyncWindowFunction<T, ACC, V, R, K, W>(aggregateFunction, windowFunction));
        }
        AggregatingStateDescriptor stateDesc = new AggregatingStateDescriptor(WINDOW_STATE_NAME, aggregateFunction, accumulatorType.createSerializer(this.config.getSerializerConfig()));
        return this.buildAsyncWindowOperator((org.apache.flink.api.common.state.v2.StateDescriptor<?>)stateDesc, (InternalAsyncWindowFunction<ACC, R, K, W>)new InternalSingleValueProcessAsyncWindowFunction<V, R, K, W>(windowFunction));
    }

    public <R> OneInputStreamOperator<T, R> apply(WindowFunction<T, R, K, W> function) {
        Preconditions.checkNotNull(function, (String)"WindowFunction cannot be null");
        return this.apply(new InternalIterableWindowFunction<T, R, K, W>(function));
    }

    public <R> OneInputStreamOperator<T, R> process(ProcessWindowFunction<T, R, K, W> function) {
        Preconditions.checkNotNull(function, (String)"ProcessWindowFunction cannot be null");
        return this.apply(new InternalIterableProcessWindowFunction<T, R, K, W>(function));
    }

    private <R> OneInputStreamOperator<T, R> apply(InternalWindowFunction<Iterable<T>, R, K, W> function) {
        if (this.evictor != null) {
            return this.buildEvictingWindowOperator(function);
        }
        org.apache.flink.api.common.state.ListStateDescriptor stateDesc = new org.apache.flink.api.common.state.ListStateDescriptor(WINDOW_STATE_NAME, this.inputType.createSerializer(this.config.getSerializerConfig()));
        return this.buildWindowOperator((StateDescriptor)stateDesc, (InternalWindowFunction)function);
    }

    public <R> OneInputStreamOperator<T, R> asyncApply(WindowFunction<T, R, K, W> function) {
        Preconditions.checkNotNull(function, (String)"WindowFunction cannot be null");
        return this.asyncApply(new InternalIterableAsyncWindowFunction<T, R, K, W>(function));
    }

    public <R> OneInputStreamOperator<T, R> asyncProcess(ProcessWindowFunction<T, R, K, W> function) {
        Preconditions.checkNotNull(function, (String)"ProcessWindowFunction cannot be null");
        return this.asyncApply(new InternalIterableProcessAsyncWindowFunction<T, R, K, W>(function));
    }

    private <R> OneInputStreamOperator<T, R> asyncApply(InternalAsyncWindowFunction<StateIterator<T>, R, K, W> function) {
        if (this.evictor != null) {
            return this.buildAsyncEvictingWindowOperator(function);
        }
        ListStateDescriptor stateDesc = new ListStateDescriptor(WINDOW_STATE_NAME, this.inputType.createSerializer(this.config.getSerializerConfig()));
        return this.buildAsyncWindowOperator((org.apache.flink.api.common.state.v2.StateDescriptor<?>)stateDesc, (InternalAsyncWindowFunction)function);
    }

    private <ACC, R> WindowOperator<K, T, ACC, R, W> buildWindowOperator(StateDescriptor<? extends AppendingState<T, ACC>, ?> stateDesc, InternalWindowFunction<ACC, R, K, W> function) {
        return new WindowOperator<K, T, ACC, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.config), this.keySelector, this.keyType.createSerializer(this.config.getSerializerConfig()), stateDesc, function, this.trigger, this.allowedLateness, this.lateDataOutputTag);
    }

    private <R> WindowOperator<K, T, Iterable<T>, R, W> buildEvictingWindowOperator(InternalWindowFunction<Iterable<T>, R, K, W> function) {
        StreamElementSerializer streamRecordSerializer = new StreamElementSerializer(this.inputType.createSerializer(this.config.getSerializerConfig()));
        org.apache.flink.api.common.state.ListStateDescriptor stateDesc = new org.apache.flink.api.common.state.ListStateDescriptor(WINDOW_STATE_NAME, streamRecordSerializer);
        return new EvictingWindowOperator<K, T, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.config), this.keySelector, this.keyType.createSerializer(this.config.getSerializerConfig()), stateDesc, function, this.trigger, this.evictor, this.allowedLateness, this.lateDataOutputTag);
    }

    private <ACC, R> AsyncWindowOperator<K, T, ACC, R, W> buildAsyncWindowOperator(org.apache.flink.api.common.state.v2.StateDescriptor<?> stateDesc, InternalAsyncWindowFunction<ACC, R, K, W> function) {
        return new AsyncWindowOperator<K, T, ACC, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.config), this.keySelector, this.keyType.createSerializer(this.config.getSerializerConfig()), stateDesc, function, this.asyncTrigger == null ? AsyncTriggerConverter.convertToAsync(this.trigger) : this.asyncTrigger, this.allowedLateness, this.lateDataOutputTag);
    }

    private <R> AsyncWindowOperator<K, T, StateIterator<T>, R, W> buildAsyncEvictingWindowOperator(InternalAsyncWindowFunction<StateIterator<T>, R, K, W> function) {
        StreamElementSerializer streamRecordSerializer = new StreamElementSerializer(this.inputType.createSerializer(this.config.getSerializerConfig()));
        ListStateDescriptor stateDesc = new ListStateDescriptor(WINDOW_STATE_NAME, streamRecordSerializer);
        return new AsyncEvictingWindowOperator<K, T, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.config), this.keySelector, this.keyType.createSerializer(this.config.getSerializerConfig()), stateDesc, function, this.asyncTrigger == null ? AsyncTriggerConverter.convertToAsync(this.trigger) : this.asyncTrigger, this.evictor, this.allowedLateness, this.lateDataOutputTag);
    }

    protected static String generateFunctionName(Function function) {
        Class<?> functionClass = function.getClass();
        if (functionClass.isAnonymousClass()) {
            Class<?>[] interfaces = functionClass.getInterfaces();
            if (interfaces.length == 0) {
                Class<?> functionSuperClass = functionClass.getSuperclass();
                return functionSuperClass.getSimpleName() + functionClass.getName().substring(functionClass.getEnclosingClass().getName().length());
            }
            Class<?> functionInterface = functionClass.getInterfaces()[0];
            return functionInterface.getSimpleName() + functionClass.getName().substring(functionClass.getEnclosingClass().getName().length());
        }
        return functionClass.getSimpleName();
    }

    public String generateOperatorName() {
        return this.windowAssigner.getClass().getSimpleName();
    }

    public String generateOperatorDescription(Function function1, @Nullable Function function2) {
        return "Window(" + String.valueOf(this.windowAssigner) + ", " + this.trigger.getClass().getSimpleName() + ", " + (String)(this.evictor == null ? "" : this.evictor.getClass().getSimpleName() + ", ") + WindowOperatorBuilder.generateFunctionName(function1) + (String)(function2 == null ? "" : ", " + WindowOperatorBuilder.generateFunctionName(function2)) + ")";
    }

    @VisibleForTesting
    public long getAllowedLateness() {
        return this.allowedLateness;
    }
}

