/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.changelog;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.StateChangelogOptions;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.state.LocalRecoveryConfig;
import org.apache.flink.runtime.state.changelog.ChangelogStateHandle;
import org.apache.flink.runtime.state.changelog.StateChangelogStorage;
import org.apache.flink.runtime.state.changelog.StateChangelogStorageFactory;
import org.apache.flink.runtime.state.changelog.StateChangelogStorageView;
import org.apache.flink.shaded.guava33.com.google.common.collect.Iterators;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class StateChangelogStorageLoader {
    private static final Logger LOG = LoggerFactory.getLogger(StateChangelogStorageLoader.class);
    private static final HashMap<String, StateChangelogStorageFactory> STATE_CHANGELOG_STORAGE_FACTORIES = new HashMap();

    public static void initialize(PluginManager pluginManager) {
        STATE_CHANGELOG_STORAGE_FACTORIES.clear();
        Iterator iterator = pluginManager == null ? ServiceLoader.load(StateChangelogStorageFactory.class).iterator() : Iterators.concat((Iterator)pluginManager.load(StateChangelogStorageFactory.class), ServiceLoader.load(StateChangelogStorageFactory.class).iterator());
        iterator.forEachRemaining(factory -> {
            String identifier = factory.getIdentifier().toLowerCase();
            StateChangelogStorageFactory prev = STATE_CHANGELOG_STORAGE_FACTORIES.get(identifier);
            if (prev == null) {
                STATE_CHANGELOG_STORAGE_FACTORIES.put(identifier, (StateChangelogStorageFactory)factory);
            } else {
                LOG.warn("StateChangelogStorageLoader found duplicated factory, using {} instead of {} for name {}.", new Object[]{prev.getClass().getName(), factory.getClass().getName(), identifier});
            }
        });
        LOG.info("StateChangelogStorageLoader initialized with shortcut names {{}}.", (Object)String.join((CharSequence)",", STATE_CHANGELOG_STORAGE_FACTORIES.keySet()));
    }

    @Nullable
    public static StateChangelogStorage<?> load(JobID jobID, Configuration configuration, TaskManagerJobMetricGroup metricGroup, LocalRecoveryConfig localRecoveryConfig) throws IOException {
        String identifier = ((String)configuration.get(StateChangelogOptions.STATE_CHANGE_LOG_STORAGE)).toLowerCase();
        StateChangelogStorageFactory factory = STATE_CHANGELOG_STORAGE_FACTORIES.get(identifier);
        if (factory == null) {
            LOG.warn("Cannot find a factory for changelog storage with name '{}'.", (Object)identifier);
            return null;
        }
        LOG.info("Creating a changelog storage with name '{}'.", (Object)identifier);
        return factory.createStorage(jobID, configuration, metricGroup, localRecoveryConfig);
    }

    @Nonnull
    public static StateChangelogStorageView<?> loadFromStateHandle(Configuration configuration, ChangelogStateHandle changelogStateHandle) throws IOException {
        StateChangelogStorageFactory factory = STATE_CHANGELOG_STORAGE_FACTORIES.get(changelogStateHandle.getStorageIdentifier());
        if (factory == null) {
            throw new FlinkRuntimeException(String.format("Cannot find a factory for changelog storage with name '%s' to restore from '%s'.", changelogStateHandle.getStorageIdentifier(), changelogStateHandle.getClass().getSimpleName()));
        }
        LOG.info("Creating a changelog storage with name '{}' to restore from '{}'.", (Object)changelogStateHandle.getStorageIdentifier(), (Object)changelogStateHandle.getClass().getSimpleName());
        return factory.createStorageView(configuration);
    }

    static {
        StateChangelogStorageLoader.initialize(null);
    }
}

