/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.util.Preconditions;

public class SubpartitionSlice {
    private final IndexRange partitionRange;
    private final IndexRange subpartitionRange;
    private final long dataBytes;

    private SubpartitionSlice(IndexRange partitionRange, IndexRange subpartitionRange, long dataBytes) {
        this.partitionRange = (IndexRange)Preconditions.checkNotNull((Object)partitionRange);
        this.subpartitionRange = (IndexRange)Preconditions.checkNotNull((Object)subpartitionRange);
        this.dataBytes = dataBytes;
    }

    public long getDataBytes() {
        return this.dataBytes;
    }

    public IndexRange getSubpartitionRange() {
        return this.subpartitionRange;
    }

    public IndexRange getPartitionRange(int numPartitions) {
        if (this.partitionRange.getEndIndex() < numPartitions) {
            return this.partitionRange;
        }
        if (this.partitionRange.getStartIndex() < numPartitions && this.partitionRange.getEndIndex() >= numPartitions) {
            return new IndexRange(this.partitionRange.getStartIndex(), numPartitions - 1);
        }
        throw new IllegalStateException("Invalid partition range " + String.valueOf(this.partitionRange) + ", number of partitions: " + numPartitions + ".");
    }

    public static SubpartitionSlice createSubpartitionSlice(IndexRange partitionRange, IndexRange subpartitionRange, long dataBytes) {
        return new SubpartitionSlice(partitionRange, subpartitionRange, dataBytes);
    }

    public static List<SubpartitionSlice> createSubpartitionSlicesByMultiPartitionRanges(List<IndexRange> partitionRanges, IndexRange subpartitionRange, Map<Integer, long[]> subpartitionBytesByPartition) {
        ArrayList<SubpartitionSlice> subpartitionSlices = new ArrayList<SubpartitionSlice>();
        for (IndexRange partitionRange : partitionRanges) {
            subpartitionSlices.add(SubpartitionSlice.createSubpartitionSlice(partitionRange, subpartitionRange, SubpartitionSlice.calculateDataBytes(partitionRange, subpartitionRange, subpartitionBytesByPartition)));
        }
        return subpartitionSlices;
    }

    private static long calculateDataBytes(IndexRange partitionRange, IndexRange subpartitionRange, Map<Integer, long[]> subpartitionBytesByPartitionIndex) {
        return IntStream.rangeClosed(partitionRange.getStartIndex(), partitionRange.getEndIndex()).mapToLong(partitionIndex -> IntStream.rangeClosed(subpartitionRange.getStartIndex(), subpartitionRange.getEndIndex()).mapToLong(subpartitionIndex -> ((long[])subpartitionBytesByPartitionIndex.get(partitionIndex))[subpartitionIndex]).sum()).sum();
    }
}

