/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.Map;
import org.apache.flink.events.EventBuilder;
import org.apache.flink.events.Events;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.executiongraph.failover.FailureHandlingResult;
import org.apache.flink.runtime.scheduler.adaptive.FailureResult;
import org.apache.flink.util.Preconditions;

public class JobFailureMetricReporter {
    public static final String FAILURE_LABEL_ATTRIBUTE_PREFIX = "failureLabel.";
    private final MetricGroup metricGroup;

    public JobFailureMetricReporter(MetricGroup metricGroup) {
        this.metricGroup = (MetricGroup)Preconditions.checkNotNull((Object)metricGroup);
    }

    public void reportJobFailure(FailureHandlingResult failureHandlingResult, Map<String, String> failureLabels) {
        this.reportJobFailure(failureHandlingResult.getTimestamp(), failureHandlingResult.canRestart(), failureHandlingResult.isGlobalFailure(), failureLabels);
    }

    public void reportJobFailure(FailureResult failureHandlingResult, Map<String, String> failureLabels) {
        this.reportJobFailure(System.currentTimeMillis(), failureHandlingResult.canRestart(), null, failureLabels);
    }

    private void reportJobFailure(long timestamp, Boolean canRestart, Boolean isGlobal, Map<String, String> failureLabels) {
        EventBuilder eventBuilder = Events.JobFailureEvent.builder(JobFailureMetricReporter.class).setObservedTsMillis(timestamp).setSeverity("INFO");
        if (canRestart != null) {
            eventBuilder.setAttribute("canRestart", String.valueOf(canRestart));
        }
        if (isGlobal != null) {
            eventBuilder.setAttribute("isGlobalFailure", String.valueOf(isGlobal));
        }
        for (Map.Entry<String, String> entry : failureLabels.entrySet()) {
            String value = entry.getValue();
            if (value == null) {
                value = "<null>";
            } else if (value.isEmpty()) {
                value = "<empty>";
            }
            eventBuilder.setAttribute(FAILURE_LABEL_ATTRIBUTE_PREFIX + entry.getKey(), value);
        }
        this.metricGroup.addEvent(eventBuilder);
    }
}

