/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.runtime.executiongraph.IndexRange;

public class IndexRangeUtil {
    public static List<IndexRange> mergeIndexRanges(Collection<IndexRange> ranges) {
        if (ranges == null || ranges.isEmpty()) {
            return new ArrayList<IndexRange>();
        }
        List sortedRanges = ranges.stream().sorted(Comparator.comparingInt(IndexRange::getStartIndex)).collect(Collectors.toList());
        ArrayList<IndexRange> merged = new ArrayList<IndexRange>();
        IndexRange current = (IndexRange)sortedRanges.get(0);
        for (int i = 1; i < ranges.size(); ++i) {
            IndexRange next = (IndexRange)sortedRanges.get(i);
            if (next.getStartIndex() <= current.getEndIndex() + 1) {
                current = new IndexRange(current.getStartIndex(), Math.max(current.getEndIndex(), next.getEndIndex()));
                continue;
            }
            merged.add(current);
            current = next;
        }
        merged.add(current);
        return merged;
    }
}

