/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing.operators.co;

import org.apache.flink.runtime.asyncprocessing.operators.co.AsyncKeyedCoProcessOperator;
import org.apache.flink.streaming.api.functions.co.KeyedCoProcessFunction;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.util.Preconditions;

public class AsyncKeyedCoProcessOperatorWithWatermarkDelay<K, IN1, IN2, OUT>
extends AsyncKeyedCoProcessOperator<K, IN1, IN2, OUT> {
    private static final long serialVersionUID = 1L;
    private final long watermarkDelay;

    public AsyncKeyedCoProcessOperatorWithWatermarkDelay(KeyedCoProcessFunction<K, IN1, IN2, OUT> keyedCoProcessFunction, long watermarkDelay) {
        super(keyedCoProcessFunction);
        Preconditions.checkArgument((watermarkDelay >= 0L ? 1 : 0) != 0, (Object)"The watermark delay should be non-negative.");
        this.watermarkDelay = watermarkDelay;
    }

    @Override
    public Watermark postProcessWatermark(Watermark watermark) throws Exception {
        if (this.watermarkDelay == 0L) {
            return watermark;
        }
        return new Watermark(watermark.getTimestamp() - this.watermarkDelay);
    }
}

