/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.benchmark;

import java.io.IOException;
import org.apache.flink.streaming.runtime.io.benchmark.StreamNetworkThroughputBenchmark;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StreamNetworkThroughputBenchmarkTest {
    StreamNetworkThroughputBenchmarkTest() {
    }

    protected StreamNetworkThroughputBenchmark createBenchmark() {
        return new StreamNetworkThroughputBenchmark();
    }

    @Test
    void pointToPointBenchmark() throws Exception {
        StreamNetworkThroughputBenchmark benchmark = this.createBenchmark();
        benchmark.setUp(1, 1, 100);
        try {
            benchmark.executeBenchmark(1000L);
        }
        finally {
            benchmark.tearDown();
        }
    }

    @Test
    void largeLocalMode() throws Exception {
        StreamNetworkThroughputBenchmark env = new StreamNetworkThroughputBenchmark();
        env.setUp(4, 10, 100, true);
        env.executeBenchmark(10000000L);
        env.tearDown();
    }

    @Test
    void largeRemoteMode() throws Exception {
        StreamNetworkThroughputBenchmark env = new StreamNetworkThroughputBenchmark();
        env.setUp(4, 10, 100, false);
        env.executeBenchmark(10000000L);
        env.tearDown();
    }

    @Test
    void largeRemoteAlwaysFlush() throws Exception {
        StreamNetworkThroughputBenchmark env = new StreamNetworkThroughputBenchmark();
        env.setUp(1, 1, 0, false);
        env.executeBenchmark(1000000L);
        env.tearDown();
    }

    @Test
    void remoteModeInsufficientBuffersSender() {
        StreamNetworkThroughputBenchmark env = new StreamNetworkThroughputBenchmark();
        int writers = 2;
        int channels = 2;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> env.setUp(writers, channels, 100, false, writers * channels - 1, writers * channels * 2)).isInstanceOf(IOException.class)).hasMessageContaining("Insufficient number of network buffers");
    }

    @Test
    void remoteModeInsufficientBuffersReceiver() throws Exception {
        StreamNetworkThroughputBenchmark env = new StreamNetworkThroughputBenchmark();
        int writers = 2;
        int channels = 2;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> env.setUp(writers, channels, 100, false, writers * channels, writers * channels * 2 - 1)).isInstanceOf(IOException.class)).hasMessageContaining("Insufficient number of network buffers");
    }

    @Test
    void remoteModeMinimumBuffers() throws Exception {
        StreamNetworkThroughputBenchmark env = new StreamNetworkThroughputBenchmark();
        int writers = 2;
        int channels = 2;
        env.setUp(writers, channels, 100, false, writers * channels + writers, writers + writers * channels * 2);
        env.executeBenchmark(10000L);
        env.tearDown();
    }

    @Test
    void pointToMultiPointBenchmark() throws Exception {
        StreamNetworkThroughputBenchmark benchmark = this.createBenchmark();
        benchmark.setUp(1, 100, 100);
        try {
            benchmark.executeBenchmark(1000L);
        }
        finally {
            benchmark.tearDown();
        }
    }

    @Test
    void multiPointToPointBenchmark() throws Exception {
        StreamNetworkThroughputBenchmark benchmark = this.createBenchmark();
        benchmark.setUp(4, 1, 100);
        try {
            benchmark.executeBenchmark(1000L);
        }
        finally {
            benchmark.tearDown();
        }
    }

    @Test
    void multiPointToMultiPointBenchmark() throws Exception {
        StreamNetworkThroughputBenchmark benchmark = this.createBenchmark();
        benchmark.setUp(4, 100, 100);
        try {
            benchmark.executeBenchmark(1000L);
        }
        finally {
            benchmark.tearDown();
        }
    }
}

