/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.apache.flink.runtime.util.ResourceManagerUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ResourceManagerUtilsTest {
    ResourceManagerUtilsTest() {
    }

    @Test
    void testParseRestBindPortFromWebInterfaceUrlWithEmptyUrl() {
        Assertions.assertThat((Integer)ResourceManagerUtils.parseRestBindPortFromWebInterfaceUrl((String)"")).isEqualTo(-1);
    }

    @Test
    void testParseRestBindPortFromWebInterfaceUrlWithNullUrl() {
        Assertions.assertThat((Integer)ResourceManagerUtils.parseRestBindPortFromWebInterfaceUrl(null)).isEqualTo(-1);
    }

    @Test
    void testParseRestBindPortFromWebInterfaceUrlWithInvalidSchema() {
        Assertions.assertThat((Integer)ResourceManagerUtils.parseRestBindPortFromWebInterfaceUrl((String)"localhost:8080//")).isEqualTo(-1);
    }

    @Test
    void testParseRestBindPortFromWebInterfaceUrlWithInvalidPort() {
        Assertions.assertThat((Integer)ResourceManagerUtils.parseRestBindPortFromWebInterfaceUrl((String)"localhost:port1")).isEqualTo(-1);
    }

    @Test
    void testParseRestBindPortFromWebInterfaceUrlWithValidPort() {
        Assertions.assertThat((Integer)ResourceManagerUtils.parseRestBindPortFromWebInterfaceUrl((String)"localhost:8080")).isEqualTo(8080);
    }
}

