/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.net.URI;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.testutils.MiniClusterResource;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.test.junit5.InjectClusterClientConfiguration;
import org.apache.flink.test.junit5.InjectClusterRESTAddress;
import org.apache.flink.test.junit5.InjectMiniCluster;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

@Internal
public class InternalMiniClusterExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
ParameterResolver,
CustomExtension {
    private final MiniClusterResource miniClusterResource;

    public InternalMiniClusterExtension(MiniClusterResourceConfiguration miniClusterResourceConfiguration) {
        this.miniClusterResource = new MiniClusterResource(miniClusterResourceConfiguration);
    }

    public int getNumberSlots() {
        return this.miniClusterResource.getNumberSlots();
    }

    public MiniCluster getMiniCluster() {
        return this.miniClusterResource.getMiniCluster();
    }

    public UnmodifiableConfiguration getClientConfiguration() {
        return this.miniClusterResource.getClientConfiguration();
    }

    public URI getRestAddress() {
        return this.miniClusterResource.getRestAddress();
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.miniClusterResource.before();
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.miniClusterResource.after();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<Object> parameterType = parameterContext.getParameter().getType();
        if (parameterContext.isAnnotated(InjectMiniCluster.class) && parameterType.isAssignableFrom(MiniCluster.class)) {
            return true;
        }
        if (parameterContext.isAnnotated(InjectClusterClientConfiguration.class) && parameterType.isAssignableFrom(UnmodifiableConfiguration.class)) {
            return true;
        }
        return parameterContext.isAnnotated(InjectClusterRESTAddress.class) && parameterType.isAssignableFrom(URI.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (parameterContext.isAnnotated(InjectMiniCluster.class)) {
            return this.miniClusterResource.getMiniCluster();
        }
        if (parameterContext.isAnnotated(InjectClusterClientConfiguration.class)) {
            return this.miniClusterResource.getClientConfiguration();
        }
        if (parameterContext.isAnnotated(InjectClusterRESTAddress.class)) {
            return this.miniClusterResource.getRestAddress();
        }
        throw new ParameterResolutionException("Unsupported parameter");
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.miniClusterResource.before();
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.miniClusterResource.after();
    }

    public void before(ExtensionContext context) throws Exception {
        this.miniClusterResource.before();
    }

    public void after(ExtensionContext context) throws Exception {
        this.miniClusterResource.after();
    }
}

