/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch.util;

import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.runtime.scheduler.adaptivebatch.BlockingInputInfo;
import org.apache.flink.runtime.scheduler.adaptivebatch.util.AllToAllVertexInputInfoComputerTest;
import org.apache.flink.runtime.scheduler.adaptivebatch.util.SubpartitionSlice;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SubpartitionSliceTest {
    @Test
    void testCreateSubpartitionSlice() {
        SubpartitionSlice subpartitionSlice = SubpartitionSlice.createSubpartitionSlice((IndexRange)new IndexRange(0, 2), (IndexRange)new IndexRange(0, 3), (long)10L);
        Assertions.assertThat((Object)subpartitionSlice.getSubpartitionRange()).isEqualTo((Object)new IndexRange(0, 3));
        Assertions.assertThat((Object)subpartitionSlice.getPartitionRange(2)).isEqualTo((Object)new IndexRange(0, 1));
        Assertions.assertThat((Object)subpartitionSlice.getPartitionRange(3)).isEqualTo((Object)new IndexRange(0, 2));
        Assertions.assertThat((Object)subpartitionSlice.getPartitionRange(4)).isEqualTo((Object)new IndexRange(0, 2));
        Assertions.assertThat((long)subpartitionSlice.getDataBytes()).isEqualTo(10L);
    }

    @Test
    void testCreateSubpartitionSlices() {
        BlockingInputInfo inputInfos = AllToAllVertexInputInfoComputerTest.createBlockingInputInfos(1, 1, 3, true, true, List.of(Integer.valueOf(1))).get(0);
        List subpartitionSlices = SubpartitionSlice.createSubpartitionSlicesByMultiPartitionRanges(List.of(new IndexRange(0, 0), new IndexRange(1, 1), new IndexRange(2, 2)), (IndexRange)new IndexRange(0, 0), (Map)inputInfos.getSubpartitionBytesByPartitionIndex());
        this.checkSubpartitionSlices(subpartitionSlices, List.of(new IndexRange(0, 0), new IndexRange(1, 1), new IndexRange(2, 2)), new IndexRange(0, 0), new long[]{1L, 1L, 1L}, 3);
        List subpartitionSlices2 = SubpartitionSlice.createSubpartitionSlicesByMultiPartitionRanges(List.of(new IndexRange(0, 1), new IndexRange(2, 2)), (IndexRange)new IndexRange(0, 0), (Map)inputInfos.getSubpartitionBytesByPartitionIndex());
        this.checkSubpartitionSlices(subpartitionSlices2, List.of(new IndexRange(0, 1), new IndexRange(2, 2)), new IndexRange(0, 0), new long[]{2L, 1L}, 3);
        List subpartitionSlices3 = SubpartitionSlice.createSubpartitionSlicesByMultiPartitionRanges(List.of(new IndexRange(0, 0), new IndexRange(1, 1), new IndexRange(2, 2)), (IndexRange)new IndexRange(1, 1), (Map)inputInfos.getSubpartitionBytesByPartitionIndex());
        this.checkSubpartitionSlices(subpartitionSlices3, List.of(new IndexRange(0, 0), new IndexRange(1, 1), new IndexRange(2, 2)), new IndexRange(1, 1), new long[]{10L, 10L, 10L}, 3);
    }

    private void checkSubpartitionSlices(List<SubpartitionSlice> subpartitionSlices, List<IndexRange> partitionRanges, IndexRange subpartitionRange, long[] dataBytes, int numPartitions) {
        for (int i = 0; i < subpartitionSlices.size(); ++i) {
            SubpartitionSlice subpartitionSlice = subpartitionSlices.get(i);
            Assertions.assertThat((Object)subpartitionSlice.getPartitionRange(numPartitions)).isEqualTo((Object)partitionRanges.get(i));
            Assertions.assertThat((Object)subpartitionSlice.getSubpartitionRange()).isEqualTo((Object)subpartitionRange);
            Assertions.assertThat((long)subpartitionSlice.getDataBytes()).isEqualTo(dataBytes[i]);
        }
    }
}

