/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.scheduler.adaptivebatch.OperatorsFinished;
import org.apache.flink.runtime.scheduler.adaptivebatch.StreamGraphOptimizationStrategy;
import org.apache.flink.runtime.scheduler.adaptivebatch.StreamGraphOptimizer;
import org.apache.flink.streaming.api.graph.StreamGraphContext;
import org.apache.flink.streaming.api.graph.util.ImmutableStreamGraph;
import org.apache.flink.streaming.api.graph.util.ImmutableStreamNode;
import org.apache.flink.streaming.api.graph.util.StreamEdgeUpdateRequestInfo;
import org.apache.flink.streaming.api.graph.util.StreamNodeUpdateRequestInfo;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class StreamGraphOptimizerTest {
    private Configuration jobConfiguration;
    private ClassLoader userClassLoader;

    StreamGraphOptimizerTest() {
    }

    @BeforeEach
    void setUp() {
        this.jobConfiguration = new Configuration();
        this.userClassLoader = Thread.currentThread().getContextClassLoader();
    }

    @Test
    void testOnOperatorsFinished() throws Exception {
        List<String> strategyClassNames = List.of(TestingStreamGraphOptimizerStrategy.class.getName());
        this.jobConfiguration.set(StreamGraphOptimizationStrategy.STREAM_GRAPH_OPTIMIZATION_STRATEGY, strategyClassNames);
        StreamGraphOptimizer optimizer = new StreamGraphOptimizer(this.jobConfiguration, this.userClassLoader);
        OperatorsFinished operatorsFinished = new OperatorsFinished(new ArrayList(), new HashMap());
        StreamGraphContext context = new StreamGraphContext(){

            public ImmutableStreamGraph getStreamGraph() {
                return null;
            }

            @Nullable
            public StreamOperatorFactory<?> getOperatorFactory(Integer streamNodeId) {
                return null;
            }

            public boolean modifyStreamEdge(List<StreamEdgeUpdateRequestInfo> requestInfos) {
                return false;
            }

            public boolean modifyStreamNode(List<StreamNodeUpdateRequestInfo> requestInfos) {
                return false;
            }

            public boolean checkUpstreamNodesFinished(ImmutableStreamNode streamNode, Integer typeNumber) {
                return false;
            }

            public IntermediateDataSetID getConsumedIntermediateDataSetId(String edgeId) {
                return null;
            }

            @Nullable
            public StreamPartitioner<?> getOutputPartitioner(String edgeId, Integer sourceId, Integer targetId) {
                return null;
            }
        };
        optimizer.onOperatorsFinished(operatorsFinished, context);
        Assertions.assertThat((Object)TestingStreamGraphOptimizerStrategy.collectedOperatorsFinished).isEqualTo((Object)operatorsFinished);
        Assertions.assertThat((Object)TestingStreamGraphOptimizerStrategy.collectedStreamGraphContext).isEqualTo((Object)context);
    }

    protected static final class TestingStreamGraphOptimizerStrategy
    implements StreamGraphOptimizationStrategy {
        private static OperatorsFinished collectedOperatorsFinished;
        private static StreamGraphContext collectedStreamGraphContext;

        protected TestingStreamGraphOptimizerStrategy() {
        }

        public boolean onOperatorsFinished(OperatorsFinished operatorsFinished, StreamGraphContext context) {
            collectedOperatorsFinished = operatorsFinished;
            collectedStreamGraphContext = context;
            return true;
        }
    }
}

