/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.allocator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.scheduler.adaptive.allocator.DefaultSlotAssigner;
import org.apache.flink.runtime.scheduler.adaptive.allocator.DefaultSlotSharingResolver;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SimpleSlotMatchingResolver;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SlotMatchingResolver;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SlotSharingResolver;
import org.apache.flink.runtime.scheduler.adaptive.allocator.TestingSlot;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
class DefaultSlotAssignerTest {
    private static final TaskManagerLocation tml1 = new LocalTaskManagerLocation();
    private static final SlotInfo slot1OfTml1 = new TestingSlot(tml1);
    private static final SlotInfo slot2OfTml1 = new TestingSlot(tml1);
    private static final SlotInfo slot3OfTml1 = new TestingSlot(tml1);
    private static final TaskManagerLocation tml2 = new LocalTaskManagerLocation();
    private static final SlotInfo slot1OfTml2 = new TestingSlot(tml2);
    private static final SlotInfo slot2OfTml2 = new TestingSlot(tml2);
    private static final SlotInfo slot3OfTml2 = new TestingSlot(tml2);
    private static final TaskManagerLocation tml3 = new LocalTaskManagerLocation();
    private static final SlotInfo slot1OfTml3 = new TestingSlot(tml3);
    private static final SlotInfo slot2OfTml3 = new TestingSlot(tml3);
    private static final List<SlotInfo> allSlots = Arrays.asList(slot1OfTml1, slot2OfTml1, slot3OfTml1, slot1OfTml2, slot2OfTml2, slot3OfTml2, slot1OfTml3, slot2OfTml3);
    @Parameter
    int parallelism;
    @Parameter(value=1)
    Collection<PhysicalSlot> freeSlots;
    @Parameter(value=2)
    List<TaskManagerLocation> expectedTaskManagerLocations;

    DefaultSlotAssignerTest() {
    }

    @TestTemplate
    void testPickSlotsIfNeeded() {
        DefaultSlotAssigner slotAssigner = new DefaultSlotAssigner("embedded", true, (SlotSharingResolver)DefaultSlotSharingResolver.INSTANCE, (SlotMatchingResolver)SimpleSlotMatchingResolver.INSTANCE);
        Set keptTaskExecutors = slotAssigner.pickSlotsIfNeeded(this.parallelism, this.freeSlots).stream().map(SlotInfo::getTaskManagerLocation).collect(Collectors.toSet());
        Assertions.assertThat(this.expectedTaskManagerLocations).containsExactlyInAnyOrderElementsOf(keptTaskExecutors);
    }

    @Parameters(name="parallelism={0}, freeSlots={1}, expectedTaskManagerLocations={2}")
    private static Collection<Object[]> getTestingParameters() {
        return Arrays.asList({4, Arrays.asList(slot1OfTml1, slot2OfTml1, slot1OfTml2, slot2OfTml3), Arrays.asList(tml1, tml2, tml3)}, {2, Arrays.asList(slot1OfTml1, slot2OfTml1, slot1OfTml2, slot2OfTml3), Collections.singletonList(tml1)}, {3, Arrays.asList(slot1OfTml1, slot1OfTml2, slot2OfTml2, slot3OfTml2), Arrays.asList(tml2)}, {7, allSlots, Arrays.asList(tml1, tml2, tml3)});
    }
}

