/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.scheduler.TestingPhysicalSlot;
import org.apache.flink.runtime.scheduler.adaptive.allocator.FreeSlotFunction;
import org.apache.flink.runtime.scheduler.adaptive.allocator.IsSlotAvailableAndFreeFunction;
import org.apache.flink.runtime.scheduler.adaptive.allocator.JobInformation;
import org.apache.flink.runtime.scheduler.adaptive.allocator.ReserveSlotFunction;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SlotSharingResolver;
import org.apache.flink.runtime.scheduler.adaptive.allocator.SlotSharingSlotAllocator;
import org.apache.flink.runtime.scheduler.adaptive.allocator.TaskBalancedSlotSharingResolver;
import org.apache.flink.runtime.scheduler.adaptive.allocator.TestJobInformation;
import org.apache.flink.runtime.scheduler.adaptive.allocator.TestVertexInformation;
import org.apache.flink.runtime.scheduler.adaptive.allocator.TestingSlot;
import org.apache.flink.runtime.scheduler.adaptive.allocator.VertexParallelism;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TaskBalancedSlotSharingResolverTest {
    private static final IsSlotAvailableAndFreeFunction is_slot_free_function = ignored -> true;
    private static final FreeSlotFunction free_slot_function = (a, c, t) -> {};
    private static final ReserveSlotFunction reserve_slot_function = (allocationId, resourceProfile) -> TestingPhysicalSlot.builder().withAllocationID(allocationId).withResourceProfile(resourceProfile).build();
    private static final boolean disable_local_recovery = false;
    private static final String NULL_EXECUTION_TARGET = null;
    private static final SlotSharingResolver slotSharingResolver = TaskBalancedSlotSharingResolver.INSTANCE;
    private static final SlotSharingSlotAllocator slotAllocator = SlotSharingSlotAllocator.createSlotSharingSlotAllocator((ReserveSlotFunction)reserve_slot_function, (FreeSlotFunction)free_slot_function, (IsSlotAvailableAndFreeFunction)is_slot_free_function, (boolean)false, (String)NULL_EXECUTION_TARGET, (boolean)false, (TaskManagerOptions.TaskManagerLoadBalanceMode)TaskManagerOptions.TaskManagerLoadBalanceMode.NONE);
    private SlotSharingGroup slotSharingGroup1;
    private SlotSharingGroup slotSharingGroup2;
    private TestVertexInformation.TestingCoLocationGroup coLocationGroup1;
    private TestVertexInformation.TestingCoLocationGroup coLocationGroup2;

    TaskBalancedSlotSharingResolverTest() {
    }

    @BeforeEach
    void setup() {
        this.slotSharingGroup1 = new SlotSharingGroup();
        this.slotSharingGroup2 = new SlotSharingGroup();
        this.coLocationGroup1 = new TestVertexInformation.TestingCoLocationGroup(new JobVertexID[0]);
        this.coLocationGroup2 = new TestVertexInformation.TestingCoLocationGroup(new JobVertexID[0]);
    }

    @Test
    void testGetExecutionSlotSharingGroupsInOneSlotSharingGroup() {
        TestVertexInformation vertex1 = new TestVertexInformation(1, this.slotSharingGroup1);
        TestVertexInformation vertex2 = new TestVertexInformation(2, this.slotSharingGroup1);
        TestVertexInformation vertex3 = new TestVertexInformation(3, this.slotSharingGroup1);
        TestJobInformation testJobInformation = new TestJobInformation(Arrays.asList(vertex1, vertex2, vertex3));
        VertexParallelism vertexParallelism = this.getVertexParallelism(testJobInformation, this.getSlotsFor(vertex1, vertex2, vertex3));
        Collection executionSlotSharingGroups = slotSharingResolver.getExecutionSlotSharingGroups((JobInformation)testJobInformation, vertexParallelism);
        Assertions.assertThat((Collection)executionSlotSharingGroups).hasSize(3);
        TaskBalancedSlotSharingResolverTest.assertExecutionSlotSharingGroupsInSlotSharingGroupsExactlyAnyOrderOf(executionSlotSharingGroups, this.slotSharingGroup1);
        TaskBalancedSlotSharingResolverTest.assertAscendingTasksPerExecutionSlotSharingGroupOfSlotSharingGroup(this.slotSharingGroup1, executionSlotSharingGroups, 2, 2, 2);
    }

    @Test
    void testGetExecutionSlotSharingGroupsInOneSlotSharingGroupWithCoLocationGroup() {
        TestVertexInformation vertex1 = new TestVertexInformation(1, this.slotSharingGroup1, this.coLocationGroup1);
        TestVertexInformation vertex2 = new TestVertexInformation(2, this.slotSharingGroup1, this.coLocationGroup1);
        TestVertexInformation vertex3 = new TestVertexInformation(3, this.slotSharingGroup1);
        TestJobInformation testJobInformation = new TestJobInformation(Arrays.asList(vertex1, vertex2, vertex3));
        VertexParallelism vertexParallelism = this.getVertexParallelism(testJobInformation, this.getSlotsFor(vertex1, vertex2, vertex3));
        Collection executionSlotSharingGroups = slotSharingResolver.getExecutionSlotSharingGroups((JobInformation)testJobInformation, vertexParallelism);
        Assertions.assertThat((Collection)executionSlotSharingGroups).hasSize(3);
        TaskBalancedSlotSharingResolverTest.assertExecutionSlotSharingGroupsInSlotSharingGroupsExactlyAnyOrderOf(executionSlotSharingGroups, this.slotSharingGroup1);
        TaskBalancedSlotSharingResolverTest.assertAscendingTasksPerExecutionSlotSharingGroupOfSlotSharingGroup(this.slotSharingGroup1, executionSlotSharingGroups, 1, 2, 3);
    }

    @Test
    void testGetExecutionSlotSharingGroupsInMultiSlotSharingGroups() {
        TestVertexInformation vertex1 = new TestVertexInformation(1, this.slotSharingGroup1);
        TestVertexInformation vertex2 = new TestVertexInformation(2, this.slotSharingGroup1);
        TestVertexInformation vertex3 = new TestVertexInformation(3, this.slotSharingGroup1);
        TestVertexInformation vertex4 = new TestVertexInformation(1, this.slotSharingGroup2);
        TestVertexInformation vertex5 = new TestVertexInformation(2, this.slotSharingGroup2);
        TestJobInformation testJobInformation = new TestJobInformation(Arrays.asList(vertex1, vertex2, vertex3, vertex4, vertex5));
        VertexParallelism vertexParallelism = this.getVertexParallelism(testJobInformation, this.getSlotsFor(vertex1, vertex2, vertex3, vertex4, vertex5));
        Collection executionSlotSharingGroups = slotSharingResolver.getExecutionSlotSharingGroups((JobInformation)testJobInformation, vertexParallelism);
        Assertions.assertThat((Collection)executionSlotSharingGroups).hasSize(5);
        TaskBalancedSlotSharingResolverTest.assertExecutionSlotSharingGroupsInSlotSharingGroupsExactlyAnyOrderOf(executionSlotSharingGroups, this.slotSharingGroup1, this.slotSharingGroup2);
        TaskBalancedSlotSharingResolverTest.assertAscendingTasksPerExecutionSlotSharingGroupOfSlotSharingGroup(this.slotSharingGroup1, executionSlotSharingGroups, 2, 2, 2);
        TaskBalancedSlotSharingResolverTest.assertAscendingTasksPerExecutionSlotSharingGroupOfSlotSharingGroup(this.slotSharingGroup2, executionSlotSharingGroups, 1, 2);
    }

    @Test
    void testGetExecutionSlotSharingGroupsInMultiSlotSharingGroupsWithCoLocationGroups() {
        TestVertexInformation vertex1 = new TestVertexInformation(1, this.slotSharingGroup1, this.coLocationGroup1);
        TestVertexInformation vertex2 = new TestVertexInformation(2, this.slotSharingGroup1, this.coLocationGroup1);
        TestVertexInformation vertex3 = new TestVertexInformation(3, this.slotSharingGroup1);
        TestVertexInformation vertex4 = new TestVertexInformation(1, this.slotSharingGroup2, this.coLocationGroup2);
        TestVertexInformation vertex5 = new TestVertexInformation(3, this.slotSharingGroup2);
        TestVertexInformation vertex6 = new TestVertexInformation(2, this.slotSharingGroup2, this.coLocationGroup2);
        TestVertexInformation vertex7 = new TestVertexInformation(1, this.slotSharingGroup2);
        TestJobInformation testJobInformation = new TestJobInformation(Arrays.asList(vertex1, vertex2, vertex3, vertex4, vertex5, vertex6, vertex7));
        VertexParallelism vertexParallelism = this.getVertexParallelism(testJobInformation, this.getSlotsFor(vertex1, vertex2, vertex3, vertex4, vertex5, vertex6, vertex7));
        Collection executionSlotSharingGroups = slotSharingResolver.getExecutionSlotSharingGroups((JobInformation)testJobInformation, vertexParallelism);
        Assertions.assertThat((Collection)executionSlotSharingGroups).hasSize(6);
        TaskBalancedSlotSharingResolverTest.assertExecutionSlotSharingGroupsInSlotSharingGroupsExactlyAnyOrderOf(executionSlotSharingGroups, this.slotSharingGroup1, this.slotSharingGroup2);
        TaskBalancedSlotSharingResolverTest.assertAscendingTasksPerExecutionSlotSharingGroupOfSlotSharingGroup(this.slotSharingGroup1, executionSlotSharingGroups, 1, 2, 3);
        TaskBalancedSlotSharingResolverTest.assertAscendingTasksPerExecutionSlotSharingGroupOfSlotSharingGroup(this.slotSharingGroup2, executionSlotSharingGroups, 2, 2, 3);
    }

    private Collection<PhysicalSlot> getSlotsFor(JobInformation.VertexInformation ... verticesInformation) {
        if (verticesInformation == null || verticesInformation.length < 1) {
            return Collections.emptyList();
        }
        int slots = Arrays.stream(verticesInformation).map(JobInformation.VertexInformation::getParallelism).reduce(0, Integer::sum);
        return TestingSlot.getSlots(slots);
    }

    private VertexParallelism getVertexParallelism(JobInformation jobInformation, Collection<PhysicalSlot> slots) {
        return slotAllocator.determineParallelism(jobInformation, slots).orElse(VertexParallelism.empty());
    }

    private static void assertExecutionSlotSharingGroupsInSlotSharingGroupsExactlyAnyOrderOf(Collection<SlotSharingSlotAllocator.ExecutionSlotSharingGroup> executionSlotSharingGroups, SlotSharingGroup ... slotSharingGroups) {
        Assertions.assertThat((Collection)executionSlotSharingGroups.stream().map(SlotSharingSlotAllocator.ExecutionSlotSharingGroup::getSlotSharingGroup).collect(Collectors.toSet())).containsExactlyInAnyOrder((Object[])slotSharingGroups);
    }

    private static void assertAscendingTasksPerExecutionSlotSharingGroupOfSlotSharingGroup(SlotSharingGroup slotSharingGroup, Collection<SlotSharingSlotAllocator.ExecutionSlotSharingGroup> executionSlotSharingGroups, Integer ... numbers) {
        Assertions.assertThat(executionSlotSharingGroups.stream().filter(essg -> essg.getSlotSharingGroup().equals(slotSharingGroup)).map(essg -> essg.getContainedExecutionVertices().size()).sorted().collect(Collectors.toList())).containsExactly((Object[])numbers);
    }
}

