/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.json;

import java.util.Optional;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.rest.messages.json.JobResultDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.util.jackson.JacksonMapperFactory;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class JobResultDeserializerTest {
    private ObjectMapper objectMapper;

    JobResultDeserializerTest() {
    }

    @BeforeEach
    void setUp() {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(JobResult.class, (JsonDeserializer)new JobResultDeserializer());
        this.objectMapper = JacksonMapperFactory.createObjectMapper();
        this.objectMapper.registerModule((Module)simpleModule);
    }

    @Test
    void testDeserialization() throws Exception {
        JobResult jobResult = (JobResult)this.objectMapper.readValue("{\n\t\"id\": \"1bb5e8c7df49938733b7c6a73678de6a\",\n\t\"accumulator-results\": {},\n\t\"net-runtime\": 0,\n\t\"unknownfield\": \"foobar\"\n}", JobResult.class);
        Assertions.assertThat((Comparable)jobResult.getJobId()).isEqualTo((Object)JobID.fromHexString((String)"1bb5e8c7df49938733b7c6a73678de6a"));
        Assertions.assertThat((long)jobResult.getNetRuntime()).isZero();
        Assertions.assertThat((int)jobResult.getAccumulatorResults().size()).isZero();
        Assertions.assertThat((Optional)jobResult.getSerializedThrowable()).isNotPresent();
    }

    @Test
    void testInvalidType() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.objectMapper.readValue("{\n\t\"id\": \"1bb5e8c7df49938733b7c6a73678de6a\",\n\t\"net-runtime\": \"invalid\"\n}", JobResult.class)).isInstanceOf(JsonMappingException.class)).hasMessageContaining("Expected token VALUE_NUMBER_INT (was VALUE_STRING)");
    }

    @Test
    void testIncompleteJobResult() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.objectMapper.readValue("{\n\t\"id\": \"1bb5e8c7df49938733b7c6a73678de6a\"\n}", JobResult.class)).isInstanceOf(JsonMappingException.class)).hasMessageContaining("Could not deserialize JobResult");
    }
}

