/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.registration;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.registration.DefaultTestRegistrationGateway;
import org.apache.flink.runtime.registration.ManualResponseTestRegistrationGateway;
import org.apache.flink.runtime.registration.RegisteredRpcConnection;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.registration.RetryingRegistration;
import org.apache.flink.runtime.registration.RetryingRegistrationTest;
import org.apache.flink.runtime.registration.TestRegistrationGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.types.Either;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;

class RegisteredRpcConnectionTest {
    private TestingRpcService rpcService;

    RegisteredRpcConnectionTest() {
    }

    @BeforeEach
    void setup() {
        this.rpcService = new TestingRpcService();
    }

    @AfterEach
    void tearDown() throws ExecutionException, InterruptedException {
        if (this.rpcService != null) {
            this.rpcService.closeAsync().get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testSuccessfulRpcConnection() throws Exception {
        String testRpcConnectionEndpointAddress = "<TestRpcConnectionEndpointAddress>";
        UUID leaderId = UUID.randomUUID();
        String connectionID = "Test RPC Connection ID";
        ManualResponseTestRegistrationGateway testGateway = new ManualResponseTestRegistrationGateway(new RegistrationResponse[]{new RetryingRegistrationTest.TestRegistrationSuccess("Test RPC Connection ID")});
        try {
            this.rpcService.registerGateway("<TestRpcConnectionEndpointAddress>", testGateway);
            TestRpcConnection connection = new TestRpcConnection("<TestRpcConnectionEndpointAddress>", leaderId, (Executor)this.rpcService.getScheduledExecutor(), this.rpcService);
            connection.start();
            Either<RetryingRegistrationTest.TestRegistrationSuccess, RetryingRegistrationTest.TestRegistrationRejection> connectionResult = connection.getConnectionFuture().get();
            Assertions.assertThat((boolean)connectionResult.isLeft()).isTrue();
            String actualConnectionId = ((RetryingRegistrationTest.TestRegistrationSuccess)((Object)connectionResult.left())).getCorrelationId();
            Assertions.assertThat((boolean)connection.isConnected()).isTrue();
            Assertions.assertThat((String)connection.getTargetAddress()).isEqualTo("<TestRpcConnectionEndpointAddress>");
            Assertions.assertThat((Comparable)((UUID)connection.getTargetLeaderId())).isEqualTo((Object)leaderId);
            Assertions.assertThat((Object)((TestRegistrationGateway)connection.getTargetGateway())).isEqualTo((Object)testGateway);
            Assertions.assertThat((String)actualConnectionId).isEqualTo("Test RPC Connection ID");
        }
        finally {
            testGateway.stop();
        }
    }

    @Test
    void testRpcConnectionFailures() throws Exception {
        String connectionFailureMessage = "Test RPC Connection failure";
        String testRpcConnectionEndpointAddress = "<TestRpcConnectionEndpointAddress>";
        UUID leaderId = UUID.randomUUID();
        RuntimeException registrationException = new RuntimeException("Test RPC Connection failure");
        DefaultTestRegistrationGateway testGateway = DefaultTestRegistrationGateway.newBuilder().setRegistrationFunction((uuid, aLong) -> {
            throw registrationException;
        }).build();
        this.rpcService.registerGateway("<TestRpcConnectionEndpointAddress>", testGateway);
        TestRpcConnection connection = new TestRpcConnection("<TestRpcConnectionEndpointAddress>", leaderId, (Executor)this.rpcService.getScheduledExecutor(), this.rpcService);
        connection.start();
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> connection.getConnectionFuture().get()).withFailMessage("expected failure.", new Object[0])).isInstanceOf(ExecutionException.class)).hasCause((Throwable)registrationException);
        Assertions.assertThat((boolean)connection.isConnected()).isFalse();
        Assertions.assertThat((String)connection.getTargetAddress()).isEqualTo("<TestRpcConnectionEndpointAddress>");
        Assertions.assertThat((Comparable)((UUID)connection.getTargetLeaderId())).isEqualTo((Object)leaderId);
        Assertions.assertThat((Object)((TestRegistrationGateway)connection.getTargetGateway())).isNull();
    }

    @Test
    void testRpcConnectionRejectionCallsOnRegistrationRejection() {
        DefaultTestRegistrationGateway testRegistrationGateway = DefaultTestRegistrationGateway.newBuilder().setRegistrationFunction((uuid, aLong) -> CompletableFuture.completedFuture(new RetryingRegistrationTest.TestRegistrationRejection(RetryingRegistrationTest.TestRegistrationRejection.RejectionReason.REJECTED))).build();
        this.rpcService.registerGateway(testRegistrationGateway.getAddress(), testRegistrationGateway);
        TestRpcConnection connection = new TestRpcConnection(testRegistrationGateway.getAddress(), UUID.randomUUID(), (Executor)this.rpcService.getScheduledExecutor(), this.rpcService);
        connection.start();
        Either<RetryingRegistrationTest.TestRegistrationSuccess, RetryingRegistrationTest.TestRegistrationRejection> connectionResult = connection.getConnectionFuture().join();
        Assertions.assertThat((boolean)connectionResult.isRight()).isTrue();
        RetryingRegistrationTest.TestRegistrationRejection registrationRejection = (RetryingRegistrationTest.TestRegistrationRejection)((Object)connectionResult.right());
        Assertions.assertThat((Comparable)((Object)registrationRejection.getRejectionReason())).isEqualTo((Object)RetryingRegistrationTest.TestRegistrationRejection.RejectionReason.REJECTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testRpcConnectionClose() throws Exception {
        String testRpcConnectionEndpointAddress = "<TestRpcConnectionEndpointAddress>";
        UUID leaderId = UUID.randomUUID();
        String connectionID = "Test RPC Connection ID";
        ManualResponseTestRegistrationGateway testGateway = new ManualResponseTestRegistrationGateway(new RegistrationResponse[]{new RetryingRegistrationTest.TestRegistrationSuccess("Test RPC Connection ID")});
        try {
            this.rpcService.registerGateway("<TestRpcConnectionEndpointAddress>", testGateway);
            TestRpcConnection connection = new TestRpcConnection("<TestRpcConnectionEndpointAddress>", leaderId, (Executor)this.rpcService.getScheduledExecutor(), this.rpcService);
            connection.start();
            connection.close();
            Assertions.assertThat((String)connection.getTargetAddress()).isEqualTo("<TestRpcConnectionEndpointAddress>");
            Assertions.assertThat((Comparable)((UUID)connection.getTargetLeaderId())).isEqualTo((Object)leaderId);
            Assertions.assertThat((boolean)connection.isClosed()).isTrue();
        }
        finally {
            testGateway.stop();
        }
    }

    @Test
    void testReconnect() throws Exception {
        String connectionId1 = "Test RPC Connection ID 1";
        String connectionId2 = "Test RPC Connection ID 2";
        String testRpcConnectionEndpointAddress = "<TestRpcConnectionEndpointAddress>";
        UUID leaderId = UUID.randomUUID();
        ManualResponseTestRegistrationGateway testGateway = new ManualResponseTestRegistrationGateway(new RegistrationResponse[]{new RetryingRegistrationTest.TestRegistrationSuccess("Test RPC Connection ID 1"), new RetryingRegistrationTest.TestRegistrationSuccess("Test RPC Connection ID 2")});
        this.rpcService.registerGateway("<TestRpcConnectionEndpointAddress>", testGateway);
        TestRpcConnection connection = new TestRpcConnection("<TestRpcConnectionEndpointAddress>", leaderId, (Executor)this.rpcService.getScheduledExecutor(), this.rpcService);
        connection.start();
        Either<RetryingRegistrationTest.TestRegistrationSuccess, RetryingRegistrationTest.TestRegistrationRejection> firstConnectionResult = connection.getConnectionFuture().get();
        Assertions.assertThat((boolean)firstConnectionResult.isLeft()).isTrue();
        String actualConnectionId1 = ((RetryingRegistrationTest.TestRegistrationSuccess)((Object)firstConnectionResult.left())).getCorrelationId();
        Assertions.assertThat((String)actualConnectionId1).isEqualTo("Test RPC Connection ID 1");
        Assertions.assertThat((boolean)connection.tryReconnect()).isTrue();
        Either<RetryingRegistrationTest.TestRegistrationSuccess, RetryingRegistrationTest.TestRegistrationRejection> secondConnectionResult = connection.getConnectionFuture().get();
        Assertions.assertThat((boolean)secondConnectionResult.isLeft()).isTrue();
        String actualConnectionId2 = ((RetryingRegistrationTest.TestRegistrationSuccess)((Object)secondConnectionResult.left())).getCorrelationId();
        Assertions.assertThat((String)actualConnectionId2).isEqualTo("Test RPC Connection ID 2");
    }

    private static class TestRpcConnection
    extends RegisteredRpcConnection<UUID, TestRegistrationGateway, RetryingRegistrationTest.TestRegistrationSuccess, RetryingRegistrationTest.TestRegistrationRejection> {
        private final Object lock = new Object();
        private final RpcService rpcService;
        private CompletableFuture<Either<RetryingRegistrationTest.TestRegistrationSuccess, RetryingRegistrationTest.TestRegistrationRejection>> connectionFuture;

        public TestRpcConnection(String targetAddress, UUID targetLeaderId, Executor executor, RpcService rpcService) {
            super(LoggerFactory.getLogger(RegisteredRpcConnectionTest.class), targetAddress, (Serializable)targetLeaderId, executor);
            this.rpcService = rpcService;
            this.connectionFuture = new CompletableFuture();
        }

        protected RetryingRegistration<UUID, TestRegistrationGateway, RetryingRegistrationTest.TestRegistrationSuccess, RetryingRegistrationTest.TestRegistrationRejection> generateRegistration() {
            return new RetryingRegistrationTest.TestRetryingRegistration(this.rpcService, this.getTargetAddress(), (UUID)this.getTargetLeaderId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onRegistrationSuccess(RetryingRegistrationTest.TestRegistrationSuccess success) {
            Object object = this.lock;
            synchronized (object) {
                this.connectionFuture.complete((Either<RetryingRegistrationTest.TestRegistrationSuccess, RetryingRegistrationTest.TestRegistrationRejection>)Either.Left((Object)((Object)success)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onRegistrationRejection(RetryingRegistrationTest.TestRegistrationRejection rejection) {
            Object object = this.lock;
            synchronized (object) {
                this.connectionFuture.complete((Either<RetryingRegistrationTest.TestRegistrationSuccess, RetryingRegistrationTest.TestRegistrationRejection>)Either.Right((Object)((Object)rejection)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onRegistrationFailure(Throwable failure) {
            Object object = this.lock;
            synchronized (object) {
                this.connectionFuture.completeExceptionally(failure);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryReconnect() {
            Object object = this.lock;
            synchronized (object) {
                this.connectionFuture.cancel(false);
                this.connectionFuture = new CompletableFuture();
            }
            return super.tryReconnect();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletableFuture<Either<RetryingRegistrationTest.TestRegistrationSuccess, RetryingRegistrationTest.TestRegistrationRejection>> getConnectionFuture() {
            Object object = this.lock;
            synchronized (object) {
                return this.connectionFuture;
            }
        }
    }
}

