/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.MetricRegistryTestUtils;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.metrics.util.DummyCharacterFilter;
import org.apache.flink.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class JobManagerGroupTest {
    JobManagerGroupTest() {
    }

    @Test
    public void addAndRemoveJobs() throws Exception {
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
        JobManagerMetricGroup group = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"localhost");
        JobID jid1 = new JobID();
        JobID jid2 = new JobID();
        String jobName1 = "testjob";
        String jobName2 = "anotherJob";
        JobManagerJobMetricGroup jmJobGroup11 = group.addJob(jid1, "testjob");
        JobManagerJobMetricGroup jmJobGroup12 = group.addJob(jid1, "testjob");
        JobManagerJobMetricGroup jmJobGroup21 = group.addJob(jid2, "anotherJob");
        Assertions.assertThat((Object)jmJobGroup12).isEqualTo((Object)jmJobGroup11);
        Assertions.assertThat((int)group.numRegisteredJobMetricGroups()).isEqualTo(2);
        group.localCleanupAsync(jid1, Executors.directExecutor()).join();
        Assertions.assertThat((boolean)jmJobGroup11.isClosed()).isTrue();
        Assertions.assertThat((int)group.numRegisteredJobMetricGroups()).isOne();
        group.localCleanupAsync(jid2, Executors.directExecutor()).join();
        Assertions.assertThat((boolean)jmJobGroup21.isClosed()).isTrue();
        Assertions.assertThat((int)group.numRegisteredJobMetricGroups()).isZero();
        registry.closeAsync().get();
    }

    @Test
    void testCloseClosesAll() throws Exception {
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
        JobManagerMetricGroup group = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"localhost");
        JobID jid1 = new JobID();
        JobID jid2 = new JobID();
        String jobName1 = "testjob";
        String jobName2 = "anotherJob";
        JobManagerJobMetricGroup jmJobGroup11 = group.addJob(jid1, "testjob");
        JobManagerJobMetricGroup jmJobGroup21 = group.addJob(jid2, "anotherJob");
        group.close();
        Assertions.assertThat((boolean)jmJobGroup11.isClosed()).isTrue();
        Assertions.assertThat((boolean)jmJobGroup21.isClosed()).isTrue();
        registry.closeAsync().get();
    }

    @Test
    void testGenerateScopeDefault() throws Exception {
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
        JobManagerMetricGroup group = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"localhost");
        Assertions.assertThat((Object[])group.getScopeComponents()).containsExactly((Object[])new String[]{"localhost", "jobmanager"});
        Assertions.assertThat((String)group.getMetricIdentifier("name")).isEqualTo("localhost.jobmanager.name");
        registry.closeAsync().get();
    }

    @Test
    void testGenerateScopeCustom() throws Exception {
        Configuration cfg = new Configuration();
        cfg.set(MetricOptions.SCOPE_NAMING_JM, (Object)"constant.<host>.foo.<host>");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(cfg));
        JobManagerMetricGroup group = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"host");
        Assertions.assertThat((Object[])group.getScopeComponents()).containsExactly((Object[])new String[]{"constant", "host", "foo", "host"});
        registry.closeAsync().get();
    }

    @Test
    void testCreateQueryServiceMetricInfo() {
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
        JobManagerMetricGroup jm = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"host");
        QueryScopeInfo.JobManagerQueryScopeInfo info = jm.createQueryServiceMetricInfo((CharacterFilter)new DummyCharacterFilter());
        Assertions.assertThat((String)info.scope).isEmpty();
    }
}

