/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.util.ResourceCounter;

final class RequirementListener {
    private final ComponentMainThreadExecutor componentMainThreadExecutor;
    private final Duration slotRequestMaxInterval;
    private ScheduledFuture<?> slotRequestFuture;
    private ResourceCounter requirements = ResourceCounter.empty();

    RequirementListener(ComponentMainThreadExecutor componentMainThreadExecutor, @Nonnull Duration slotRequestMaxInterval) {
        this.componentMainThreadExecutor = componentMainThreadExecutor;
        this.slotRequestMaxInterval = slotRequestMaxInterval;
    }

    void increaseRequirements(ResourceCounter requirements) {
        if (this.slotRequestMaxInterval.toMillis() <= 0L) {
            this.requirements = this.requirements.add(requirements);
            return;
        }
        if (!this.slotSlotRequestFutureAssignable()) {
            this.slotRequestFuture.cancel(true);
        }
        this.slotRequestFuture = this.componentMainThreadExecutor.schedule(() -> this.checkSlotRequestMaxInterval(requirements), this.slotRequestMaxInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    void decreaseRequirements(ResourceCounter requirements) {
        this.requirements = this.requirements.subtract(requirements);
    }

    ResourceCounter getRequirements() {
        return this.requirements;
    }

    void tryWaitSlotRequestIsDone() {
        if (Objects.nonNull(this.slotRequestFuture)) {
            try {
                this.slotRequestFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean slotSlotRequestFutureAssignable() {
        return this.slotRequestFuture == null || this.slotRequestFuture.isDone() || this.slotRequestFuture.isCancelled();
    }

    private void checkSlotRequestMaxInterval(ResourceCounter requirements) {
        if (this.slotRequestMaxInterval.toMillis() <= 0L) {
            return;
        }
        this.requirements = this.requirements.add(requirements);
    }
}

