/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategyTest;
import org.apache.flink.runtime.jobmaster.slotpool.PreviousAllocationSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PreviousAllocationSlotSelectionStrategyTest
extends LocationPreferenceSlotSelectionStrategyTest {
    PreviousAllocationSlotSelectionStrategyTest() {
    }

    @Override
    @BeforeEach
    void setUp() {
        this.selectionStrategy = PreviousAllocationSlotSelectionStrategy.create();
    }

    @Test
    void matchPreviousAllocationOverridesPreferredLocation() {
        SlotProfile slotProfile = SlotProfile.priorAllocation((ResourceProfile)this.resourceProfile, (ResourceProfile)this.resourceProfile, Collections.singletonList(this.tml2), Collections.singleton(this.aid3), Collections.emptySet());
        Optional<SlotSelectionStrategy.SlotInfoAndLocality> match = this.runMatching(slotProfile);
        PreviousAllocationSlotSelectionStrategyTest.assertMatchingSlotEqualsToSlotInfo(match, (SlotInfo)this.slot3);
        slotProfile = SlotProfile.priorAllocation((ResourceProfile)this.resourceProfile, (ResourceProfile)this.resourceProfile, Arrays.asList(this.tmlX, this.tml1), new HashSet<AllocationID>(Arrays.asList(this.aidX, this.aid2)), Collections.emptySet());
        match = this.runMatching(slotProfile);
        PreviousAllocationSlotSelectionStrategyTest.assertMatchingSlotEqualsToSlotInfo(match, (SlotInfo)this.slot2);
    }

    @Test
    void matchPreviousLocationNotAvailableButByLocality() {
        SlotProfile slotProfile = SlotProfile.priorAllocation((ResourceProfile)this.resourceProfile, (ResourceProfile)this.resourceProfile, Collections.singletonList(this.tml4), Collections.singleton(this.aidX), Collections.emptySet());
        Optional<SlotSelectionStrategy.SlotInfoAndLocality> match = this.runMatching(slotProfile);
        PreviousAllocationSlotSelectionStrategyTest.assertMatchingSlotEqualsToSlotInfo(match, (SlotInfo)this.slot4);
    }

    @Test
    void matchPreviousLocationNotAvailableAndAllOthersBlacklisted() {
        HashSet<AllocationID> blacklisted = new HashSet<AllocationID>(4);
        blacklisted.add(this.aid1);
        blacklisted.add(this.aid2);
        blacklisted.add(this.aid3);
        blacklisted.add(this.aid4);
        SlotProfile slotProfile = SlotProfile.priorAllocation((ResourceProfile)this.resourceProfile, (ResourceProfile)this.resourceProfile, Collections.singletonList(this.tml4), Collections.singletonList(this.aidX), blacklisted);
        Optional<SlotSelectionStrategy.SlotInfoAndLocality> match = this.runMatching(slotProfile);
        Assertions.assertThat(match).isNotPresent();
    }

    @Test
    void matchPreviousLocationNotAvailableAndSomeOthersBlacklisted() {
        HashSet<AllocationID> blacklisted = new HashSet<AllocationID>(3);
        blacklisted.add(this.aid2);
        blacklisted.add(this.aid3);
        blacklisted.add(this.aid4);
        SlotProfile slotProfile = SlotProfile.priorAllocation((ResourceProfile)this.resourceProfile, (ResourceProfile)this.resourceProfile, Collections.singletonList(this.tml4), Collections.singletonList(this.aidX), blacklisted);
        Optional<SlotSelectionStrategy.SlotInfoAndLocality> match = this.runMatching(slotProfile);
        PreviousAllocationSlotSelectionStrategyTest.assertMatchingSlotEqualsToSlotInfo(match, (SlotInfo)this.slot1);
    }
}

