/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.api.common.io.GenericInputFormat;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.runtime.jobgraph.InputOutputFormatContainer;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.junit.Assert;
import org.junit.Test;

public class InputOutputFormatContainerTest {
    @Test
    public void testInputOutputFormat() {
        InputOutputFormatContainer formatContainer = new InputOutputFormatContainer(Thread.currentThread().getContextClassLoader());
        OperatorID operatorID1 = new OperatorID();
        formatContainer.addInputFormat(operatorID1, (InputFormat)new TestInputFormat("test input format"));
        formatContainer.addParameters(operatorID1, "parameter1", "abc123");
        OperatorID operatorID2 = new OperatorID();
        formatContainer.addOutputFormat(operatorID2, new TestOutputFormat());
        formatContainer.addParameters(operatorID2, "parameter1", "bcd234");
        OperatorID operatorID3 = new OperatorID();
        formatContainer.addOutputFormat(operatorID3, new TestOutputFormat());
        formatContainer.addParameters(operatorID3, "parameter1", "cde345");
        TaskConfig taskConfig = new TaskConfig(new Configuration());
        formatContainer.write(taskConfig);
        InputOutputFormatContainer loadedFormatContainer = new InputOutputFormatContainer(taskConfig, this.getClass().getClassLoader());
        Map inputFormats = loadedFormatContainer.getInputFormats();
        Map outputFormats = loadedFormatContainer.getOutputFormats();
        Assert.assertEquals((long)1L, (long)inputFormats.size());
        Assert.assertEquals((long)2L, (long)outputFormats.size());
        TestInputFormat inputFormat = (TestInputFormat)((Object)((UserCodeWrapper)inputFormats.get(operatorID1)).getUserCodeObject());
        Assert.assertEquals((Object)"test input format", (Object)inputFormat.getName());
        Configuration inputFormatParams = loadedFormatContainer.getParameters(operatorID1);
        Assert.assertEquals((long)1L, (long)inputFormatParams.keySet().size());
        Assert.assertEquals((Object)"abc123", (Object)inputFormatParams.getString("parameter1", null));
        Assert.assertTrue((boolean)(((UserCodeWrapper)outputFormats.get(operatorID2)).getUserCodeObject() instanceof TestOutputFormat));
        Configuration outputFormatParams1 = loadedFormatContainer.getParameters(operatorID2);
        Assert.assertEquals((long)1L, (long)outputFormatParams1.keySet().size());
        Assert.assertEquals((Object)"bcd234", (Object)outputFormatParams1.getString("parameter1", null));
        Assert.assertTrue((boolean)(((UserCodeWrapper)outputFormats.get(operatorID3)).getUserCodeObject() instanceof TestOutputFormat));
        Configuration outputFormatParams2 = loadedFormatContainer.getParameters(operatorID3);
        Assert.assertEquals((long)1L, (long)outputFormatParams2.keySet().size());
        Assert.assertEquals((Object)"cde345", (Object)outputFormatParams2.getString("parameter1", null));
    }

    @Test
    public void testOnlyInputFormat() {
        InputOutputFormatContainer formatContainer = new InputOutputFormatContainer(Thread.currentThread().getContextClassLoader());
        OperatorID operatorID = new OperatorID();
        formatContainer.addInputFormat(operatorID, (InputFormat)new TestInputFormat("test input format"));
        formatContainer.addParameters(operatorID, "parameter1", "abc123");
        TaskConfig taskConfig = new TaskConfig(new Configuration());
        formatContainer.write(taskConfig);
        InputOutputFormatContainer loadedFormatContainer = new InputOutputFormatContainer(taskConfig, this.getClass().getClassLoader());
        Map inputFormats = loadedFormatContainer.getInputFormats();
        Assert.assertEquals((long)1L, (long)inputFormats.size());
        Assert.assertEquals((long)0L, (long)loadedFormatContainer.getOutputFormats().size());
        TestInputFormat inputFormat = (TestInputFormat)((Object)((UserCodeWrapper)inputFormats.get(operatorID)).getUserCodeObject());
        Assert.assertEquals((Object)"test input format", (Object)inputFormat.getName());
        Configuration parameters = loadedFormatContainer.getParameters(operatorID);
        Assert.assertEquals((long)1L, (long)parameters.keySet().size());
        Assert.assertEquals((Object)"abc123", (Object)parameters.getString("parameter1", null));
    }

    @Test
    public void testOnlyOutputFormat() {
        InputOutputFormatContainer formatContainer = new InputOutputFormatContainer(Thread.currentThread().getContextClassLoader());
        OperatorID operatorID = new OperatorID();
        formatContainer.addOutputFormat(operatorID, new TestOutputFormat());
        Configuration parameters = new Configuration();
        parameters.setString("parameter1", "bcd234");
        formatContainer.addParameters(operatorID, parameters);
        TaskConfig taskConfig = new TaskConfig(new Configuration());
        formatContainer.write(taskConfig);
        InputOutputFormatContainer loadedFormatContainer = new InputOutputFormatContainer(taskConfig, this.getClass().getClassLoader());
        Map outputFormats = loadedFormatContainer.getOutputFormats();
        Assert.assertEquals((long)1L, (long)outputFormats.size());
        Assert.assertEquals((long)0L, (long)loadedFormatContainer.getInputFormats().size());
        Assert.assertTrue((boolean)(((UserCodeWrapper)outputFormats.get(operatorID)).getUserCodeObject() instanceof TestOutputFormat));
        Configuration loadedParameters = loadedFormatContainer.getParameters(operatorID);
        Assert.assertEquals((long)1L, (long)loadedParameters.keySet().size());
        Assert.assertEquals((Object)"bcd234", (Object)loadedParameters.getString("parameter1", null));
    }

    private static final class TestOutputFormat<T>
    implements OutputFormat<T> {
        private static final long serialVersionUID = 1L;

        private TestOutputFormat() {
        }

        public void configure(Configuration parameters) {
        }

        public void open(OutputFormat.InitializationContext context) throws IOException {
        }

        public void writeRecord(T record) {
        }

        public void close() {
        }
    }

    private static final class TestInputFormat
    extends GenericInputFormat<Object> {
        private final String name;

        TestInputFormat(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean reachedEnd() {
            return true;
        }

        public Object nextRecord(Object reuse) {
            return null;
        }

        public GenericInputSplit[] createInputSplits(int numSplits) {
            return null;
        }
    }
}

