/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty;

import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageInputChannelId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.TestingTierConsumerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.TestingTieredStorageNettyService;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.TieredStorageNettyService;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.AvailabilityNotifier;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TestingTierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageConsumerClient;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageConsumerSpec;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierConsumerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleDescriptor;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.TestingAvailabilityNotifier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TieredStorageConsumerClientTest {
    private static final TieredStoragePartitionId DEFAULT_PARTITION_ID = TieredStorageIdMappingUtils.convertId((ResultPartitionID)new ResultPartitionID());
    private static final TieredStorageSubpartitionId DEFAULT_SUBPARTITION_ID = new TieredStorageSubpartitionId(0);
    private static final TieredStorageInputChannelId DEFAULT_INPUT_CHANNEL_ID = new TieredStorageInputChannelId(0);
    private static final ResultSubpartitionIndexSet DEFAULT_SUBPARTITION_ID_SET = new ResultSubpartitionIndexSet(0);

    TieredStorageConsumerClientTest() {
    }

    @Test
    void testStart() {
        CompletableFuture future = new CompletableFuture();
        TestingTierConsumerAgent tierConsumerAgent = new TestingTierConsumerAgent.Builder().setStartNotifier(() -> future.complete(null)).build();
        TieredStorageConsumerClient consumerClient = this.createTieredStorageConsumerClient(tierConsumerAgent);
        consumerClient.start();
        Assertions.assertThat(future).isDone();
    }

    @Test
    void testGetNextBuffer() throws IOException {
        Buffer buffer = BufferBuilderTestUtils.buildSomeBuffer(0);
        TestingTierConsumerAgent tierConsumerAgent = new TestingTierConsumerAgent.Builder().setBufferSupplier(() -> buffer).build();
        TieredStorageConsumerClient consumerClient = this.createTieredStorageConsumerClient(tierConsumerAgent);
        Assertions.assertThat((Optional)consumerClient.getNextBuffer(DEFAULT_PARTITION_ID, DEFAULT_SUBPARTITION_ID)).hasValue((Object)buffer);
    }

    @Test
    void testRegisterAvailabilityNotifier() {
        CompletableFuture future = new CompletableFuture();
        TestingTierConsumerAgent tierConsumerAgent = new TestingTierConsumerAgent.Builder().setAvailabilityNotifierRegistrationRunnable(() -> future.complete(null)).build();
        TieredStorageConsumerClient consumerClient = this.createTieredStorageConsumerClient(tierConsumerAgent);
        consumerClient.registerAvailabilityNotifier((AvailabilityNotifier)new TestingAvailabilityNotifier.Builder().build());
        Assertions.assertThat(future).isDone();
    }

    @Test
    void testUpdateTierShuffleDescriptor() {
        CompletableFuture future = new CompletableFuture();
        TestingTierConsumerAgent tierConsumerAgent = new TestingTierConsumerAgent.Builder().setUpdateTierShuffleDescriptorRunnable(() -> future.complete(null)).build();
        Assertions.assertThat(future).isNotDone();
        TieredStorageConsumerClient consumerClient = this.createTieredStorageConsumerClient(tierConsumerAgent);
        consumerClient.updateTierShuffleDescriptors(DEFAULT_PARTITION_ID, DEFAULT_INPUT_CHANNEL_ID, DEFAULT_SUBPARTITION_ID, Collections.singletonList(new TierShuffleDescriptor(){
            private static final long serialVersionUID = 1L;
        }));
        Assertions.assertThat(future).isDone();
    }

    @Test
    void testClose() throws IOException {
        CompletableFuture future = new CompletableFuture();
        TestingTierConsumerAgent tierConsumerAgent = new TestingTierConsumerAgent.Builder().setCloseNotifier(() -> future.complete(null)).build();
        TieredStorageConsumerClient consumerClient = this.createTieredStorageConsumerClient(tierConsumerAgent);
        consumerClient.close();
        Assertions.assertThat(future).isDone();
    }

    private TieredStorageConsumerClient createTieredStorageConsumerClient(TierConsumerAgent tierConsumerAgent) {
        TierShuffleDescriptor emptyTierShuffleDescriptor = new TierShuffleDescriptor(){
            private static final long serialVersionUID = 1L;
        };
        return new TieredStorageConsumerClient(Collections.singletonList(new TestingTierFactory.Builder().setTierConsumerAgentSupplier((tieredStorageConsumerSpecs, nettyService) -> tierConsumerAgent).build()), Collections.singletonList(new TieredStorageConsumerSpec(0, DEFAULT_PARTITION_ID, DEFAULT_INPUT_CHANNEL_ID, DEFAULT_SUBPARTITION_ID_SET)), Collections.singletonList(Collections.singletonList(emptyTierShuffleDescriptor)), (TieredStorageNettyService)new TestingTieredStorageNettyService.Builder().build());
    }
}

