/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty;

import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyConnectionReader;

public class TestingNettyConnectionReader
implements NettyConnectionReader {
    private final Function<Integer, Buffer> readBufferFunction;
    private final Supplier<Integer> peekNextBufferSubpartitionIdSupplier;

    private TestingNettyConnectionReader(Function<Integer, Buffer> readBufferFunction, Supplier<Integer> peekNextBufferSubpartitionIdSupplier) {
        this.readBufferFunction = readBufferFunction;
        this.peekNextBufferSubpartitionIdSupplier = peekNextBufferSubpartitionIdSupplier;
    }

    public int peekNextBufferSubpartitionId() throws IOException {
        return this.peekNextBufferSubpartitionIdSupplier.get();
    }

    public Optional<Buffer> readBuffer(int subpartitionId, int segmentId) {
        return Optional.of(this.readBufferFunction.apply(segmentId));
    }

    public static class Builder {
        private Function<Integer, Buffer> readBufferFunction = segmentId -> null;
        private Supplier<Integer> peekNextBufferSubpartitionIdSupplier = () -> -1;

        public Builder setReadBufferFunction(Function<Integer, Buffer> readBufferFunction) {
            this.readBufferFunction = readBufferFunction;
            return this;
        }

        public Builder setPeekNextBufferSubpartitionIdSupplier(Supplier<Integer> peekNextBufferSubpartitionIdSupplier) {
            this.peekNextBufferSubpartitionIdSupplier = peekNextBufferSubpartitionIdSupplier;
            return this;
        }

        public TestingNettyConnectionReader build() {
            return new TestingNettyConnectionReader(this.readBufferFunction, this.peekNextBufferSubpartitionIdSupplier);
        }
    }
}

