/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.Optional;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.io.network.partition.AbstractPartitionTracker;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.shuffle.PartitionDescriptorBuilder;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class AbstractPartitionTrackerTest {
    @Test
    void testStartStopTracking() {
        TestPartitionTracker partitionTracker = new TestPartitionTracker();
        ResourceID executorWithTrackedPartition = new ResourceID("tracked");
        ResourceID executorWithoutTrackedPartition = new ResourceID("untracked");
        Assertions.assertThat((boolean)partitionTracker.isTrackingPartitionsFor(executorWithTrackedPartition)).isFalse();
        Assertions.assertThat((boolean)partitionTracker.isTrackingPartitionsFor(executorWithoutTrackedPartition)).isFalse();
        partitionTracker.startTrackingPartition(executorWithTrackedPartition, new ResultPartitionID());
        Assertions.assertThat((boolean)partitionTracker.isTrackingPartitionsFor(executorWithTrackedPartition)).isTrue();
        Assertions.assertThat((boolean)partitionTracker.isTrackingPartitionsFor(executorWithoutTrackedPartition)).isFalse();
        partitionTracker.stopTrackingPartitionsFor(executorWithTrackedPartition);
        Assertions.assertThat((boolean)partitionTracker.isTrackingPartitionsFor(executorWithTrackedPartition)).isFalse();
        Assertions.assertThat((boolean)partitionTracker.isTrackingPartitionsFor(executorWithoutTrackedPartition)).isFalse();
    }

    public static ResultPartitionDeploymentDescriptor createResultPartitionDeploymentDescriptor(ResultPartitionID resultPartitionId, boolean hasLocalResources) {
        return AbstractPartitionTrackerTest.createResultPartitionDeploymentDescriptor(resultPartitionId, ResultPartitionType.BLOCKING, hasLocalResources);
    }

    static ResultPartitionDeploymentDescriptor createResultPartitionDeploymentDescriptor(final ResultPartitionID resultPartitionId, ResultPartitionType type, final boolean hasLocalResources) {
        return new ResultPartitionDeploymentDescriptor(PartitionDescriptorBuilder.newBuilder().setPartitionId(resultPartitionId.getPartitionId()).setPartitionType(type).build(), new ShuffleDescriptor(){

            public ResultPartitionID getResultPartitionID() {
                return resultPartitionId;
            }

            public Optional<ResourceID> storesLocalResourcesOn() {
                return hasLocalResources ? Optional.of(ResourceID.generate()) : Optional.empty();
            }
        }, 1);
    }

    private static class TestPartitionTracker
    extends AbstractPartitionTracker<ResourceID, Integer> {
        private TestPartitionTracker() {
        }

        public void startTrackingPartition(ResourceID key, ResultPartitionID resultPartitionID) {
            this.startTrackingPartition(key, resultPartitionID, 0);
        }
    }
}

