/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Deadline;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.testutils.AllCallbackWrapper;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.zookeeper.ZooKeeperExtension;
import org.apache.flink.streaming.api.graph.ExecutionPlan;
import org.apache.flink.test.junit5.InjectMiniCluster;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorExtension;
import org.apache.flink.util.TestLoggerExtension;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.apache.flink.util.concurrent.ScheduledExecutorServiceAdapter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.RegisterExtension;

@ExtendWith(value={TestLoggerExtension.class})
public abstract class AbstractHAJobRunITCase {
    @RegisterExtension
    static final TestExecutorExtension<ScheduledExecutorService> EXECUTOR_RESOURCE = TestingUtils.defaultExecutorExtension();
    @RegisterExtension
    @Order(value=1)
    private static final AllCallbackWrapper<ZooKeeperExtension> ZOOKEEPER_EXTENSION = new AllCallbackWrapper((CustomExtension)new ZooKeeperExtension());

    protected static Configuration addHaConfiguration(Configuration config, String haStoragePath) {
        config.set(HighAvailabilityOptions.HA_MODE, (Object)"ZOOKEEPER");
        config.set(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, (Object)((ZooKeeperExtension)ZOOKEEPER_EXTENSION.getCustomExtension()).getConnectString());
        config.set(HighAvailabilityOptions.HA_STORAGE_PATH, (Object)haStoragePath);
        FileSystem.initialize((Configuration)config, null);
        return config;
    }

    protected void runAfterJobTermination() throws Exception {
    }

    @Test
    public void testJobExecutionInHaMode(@InjectMiniCluster MiniCluster flinkCluster) throws Exception {
        JobGraph jobGraph = JobGraphTestUtils.singleNoOpJobGraph();
        flinkCluster.submitJob((ExecutionPlan)jobGraph).get(30L, TimeUnit.SECONDS);
        Deadline deadline = Deadline.fromNow((Duration)Duration.ofSeconds(30L));
        JobStatus jobStatus = (JobStatus)FutureUtils.retrySuccessfulWithDelay(() -> flinkCluster.getJobStatus(jobGraph.getJobID()), (Duration)Duration.ofMillis(10L), (Deadline)deadline, status -> flinkCluster.isRunning() && status == JobStatus.FINISHED, (ScheduledExecutor)new ScheduledExecutorServiceAdapter((ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor())).get(deadline.timeLeft().toMillis(), TimeUnit.MILLISECONDS);
        Assertions.assertThat((Comparable)jobStatus).isEqualTo((Object)JobStatus.FINISHED);
        this.runAfterJobTermination();
    }
}

