/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution.librarycache;

import java.util.function.Function;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.execution.librarycache.TestingClassLoaderLease;

public class TestingLibraryCacheManager
implements LibraryCacheManager {
    private final Function<JobID, LibraryCacheManager.ClassLoaderLease> registerOrRetainClassLoaderFunction;
    private final Runnable shutdownRunnable;

    private TestingLibraryCacheManager(Function<JobID, LibraryCacheManager.ClassLoaderLease> registerOrRetainClassLoaderFunction, Runnable shutdownRunnable) {
        this.registerOrRetainClassLoaderFunction = registerOrRetainClassLoaderFunction;
        this.shutdownRunnable = shutdownRunnable;
    }

    public LibraryCacheManager.ClassLoaderLease registerClassLoaderLease(JobID jobId) {
        return this.registerOrRetainClassLoaderFunction.apply(jobId);
    }

    public void shutdown() {
        this.shutdownRunnable.run();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Runnable shutdownRunnable = () -> {};
        private Function<JobID, LibraryCacheManager.ClassLoaderLease> registerOrRetainClassLoaderFunction = ignored -> TestingClassLoaderLease.newBuilder().build();

        private Builder() {
        }

        public Builder setShutdownRunnable(Runnable shutdownRunnable) {
            this.shutdownRunnable = shutdownRunnable;
            return this;
        }

        public Builder setRegisterOrRetainClassLoaderFunction(Function<JobID, LibraryCacheManager.ClassLoaderLease> registerOrRetainClassLoaderFunction) {
            this.registerOrRetainClassLoaderFunction = registerOrRetainClassLoaderFunction;
            return this;
        }

        public TestingLibraryCacheManager build() {
            return new TestingLibraryCacheManager(this.registerOrRetainClassLoaderFunction, this.shutdownRunnable);
        }
    }
}

