/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobmaster.TestingJobManagerRunner;
import org.apache.flink.util.Preconditions;

public class TestingJobManagerRunnerFactory {
    private final BlockingQueue<TestingJobManagerRunner> createdJobManagerRunner = new ArrayBlockingQueue<TestingJobManagerRunner>(16);
    private final AtomicInteger numBlockingJobManagerRunners;

    protected TestingJobManagerRunnerFactory(int numBlockingJobManagerRunners) {
        this.numBlockingJobManagerRunners = new AtomicInteger(numBlockingJobManagerRunners);
    }

    protected TestingJobManagerRunner offerTestingJobManagerRunner(JobID jobId) {
        TestingJobManagerRunner testingJobManagerRunner = this.createTestingJobManagerRunner(jobId);
        Preconditions.checkState((boolean)this.createdJobManagerRunner.offer(testingJobManagerRunner), (Object)"Unable to persist created the new runner.");
        return testingJobManagerRunner;
    }

    private TestingJobManagerRunner createTestingJobManagerRunner(JobID jobId) {
        boolean blockingTermination = this.numBlockingJobManagerRunners.getAndDecrement() > 0;
        return TestingJobManagerRunner.newBuilder().setJobId(jobId).setBlockingTermination(blockingTermination).build();
    }

    public TestingJobManagerRunner takeCreatedJobManagerRunner() throws InterruptedException {
        return this.createdJobManagerRunner.take();
    }

    public int getQueueSize() {
        return this.createdJobManagerRunner.size();
    }
}

