/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.runtime.checkpoint.Checkpoints;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointMetadata;
import org.apache.flink.runtime.checkpoint.metadata.MetadataSerializer;
import org.apache.flink.runtime.checkpoint.metadata.MetadataV3Serializer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class CheckpointsTest {
    CheckpointsTest() {
    }

    @Test
    void testVersion3Compatibility() throws IOException {
        CheckpointMetadata metadata = new CheckpointMetadata(1L, Collections.emptyList(), Collections.emptyList(), null);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(out);){
            Checkpoints.storeCheckpointMetadata((CheckpointMetadata)metadata, (DataOutputStream)dos, (MetadataSerializer)MetadataV3Serializer.INSTANCE);
            try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(out.toByteArray()));){
                CheckpointMetadata deserialized = Checkpoints.loadCheckpointMetadata((DataInputStream)dis, (ClassLoader)metadata.getClass().getClassLoader(), (String)"");
                Assertions.assertThat((Object)deserialized.getCheckpointProperties()).isNull();
                Assertions.assertThat((long)deserialized.getCheckpointId()).isEqualTo(metadata.getCheckpointId());
                Assertions.assertThat((Collection)deserialized.getOperatorStates()).isEqualTo((Object)metadata.getOperatorStates());
                Assertions.assertThat((Collection)deserialized.getMasterStates()).isEqualTo((Object)metadata.getMasterStates());
            }
        }
    }
}

