/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Iterator;
import org.apache.flink.runtime.checkpoint.AbstractCheckpointStats;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CheckpointStatsHistory;
import org.apache.flink.runtime.checkpoint.CheckpointStatsStatus;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.FailedCheckpointStats;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class CheckpointStatsHistoryTest {
    CheckpointStatsHistoryTest() {
    }

    @Test
    void testZeroMaxSizeHistory() {
        CheckpointStatsHistory history = new CheckpointStatsHistory(0);
        history.addInProgressCheckpoint(this.createPendingCheckpointStats(0L));
        Assertions.assertThat((boolean)history.replacePendingCheckpointById((AbstractCheckpointStats)this.createCompletedCheckpointStats(0L))).isFalse();
        CheckpointStatsHistory snapshot = history.createSnapshot();
        int counter = 0;
        for (AbstractCheckpointStats ignored : snapshot.getCheckpoints()) {
            ++counter;
        }
        Assertions.assertThat((int)counter).isZero();
        Assertions.assertThat((Object)snapshot.getCheckpointById(0L)).isNotNull();
    }

    @Test
    void testSizeOneHistory() {
        CheckpointStatsHistory history = new CheckpointStatsHistory(1);
        history.addInProgressCheckpoint(this.createPendingCheckpointStats(0L));
        history.addInProgressCheckpoint(this.createPendingCheckpointStats(1L));
        Assertions.assertThat((boolean)history.replacePendingCheckpointById((AbstractCheckpointStats)this.createCompletedCheckpointStats(0L))).isFalse();
        Assertions.assertThat((boolean)history.replacePendingCheckpointById((AbstractCheckpointStats)this.createCompletedCheckpointStats(1L))).isTrue();
        CheckpointStatsHistory snapshot = history.createSnapshot();
        for (AbstractCheckpointStats stats : snapshot.getCheckpoints()) {
            Assertions.assertThat((long)stats.getCheckpointId()).isOne();
            Assertions.assertThat((boolean)stats.getStatus().isCompleted()).isTrue();
        }
    }

    @Test
    void testCheckpointHistory() throws Exception {
        CheckpointStatsHistory history = new CheckpointStatsHistory(3);
        history.addInProgressCheckpoint(this.createPendingCheckpointStats(0L));
        CheckpointStatsHistory snapshot = history.createSnapshot();
        for (AbstractCheckpointStats stats : snapshot.getCheckpoints()) {
            Assertions.assertThat((long)stats.getCheckpointId()).isZero();
            Assertions.assertThat((boolean)stats.getStatus().isInProgress()).isTrue();
        }
        history.addInProgressCheckpoint(this.createPendingCheckpointStats(1L));
        history.addInProgressCheckpoint(this.createPendingCheckpointStats(2L));
        history.addInProgressCheckpoint(this.createPendingCheckpointStats(3L));
        snapshot = history.createSnapshot();
        Iterator it = snapshot.getCheckpoints().iterator();
        for (int i = 3; i > 0; --i) {
            Assertions.assertThat(it).hasNext();
            AbstractCheckpointStats stats = (AbstractCheckpointStats)it.next();
            Assertions.assertThat((long)stats.getCheckpointId()).isEqualTo((long)i);
            Assertions.assertThat((boolean)stats.getStatus().isInProgress()).isTrue();
        }
        Assertions.assertThat(it).isExhausted();
        history.replacePendingCheckpointById((AbstractCheckpointStats)this.createFailedCheckpointStats(1L));
        history.replacePendingCheckpointById((AbstractCheckpointStats)this.createCompletedCheckpointStats(3L));
        history.replacePendingCheckpointById((AbstractCheckpointStats)this.createFailedCheckpointStats(2L));
        snapshot = history.createSnapshot();
        it = snapshot.getCheckpoints().iterator();
        Assertions.assertThat(it).hasNext();
        AbstractCheckpointStats stats = (AbstractCheckpointStats)it.next();
        Assertions.assertThat((long)stats.getCheckpointId()).isEqualTo(3L);
        Assertions.assertThat((Object)snapshot.getCheckpointById(3L)).isNotNull();
        Assertions.assertThat((boolean)stats.getStatus().isCompleted()).isTrue();
        Assertions.assertThat((boolean)snapshot.getCheckpointById(3L).getStatus().isCompleted()).isTrue();
        Assertions.assertThat(it).hasNext();
        stats = (AbstractCheckpointStats)it.next();
        Assertions.assertThat((long)stats.getCheckpointId()).isEqualTo(2L);
        Assertions.assertThat((Object)snapshot.getCheckpointById(2L)).isNotNull();
        Assertions.assertThat((boolean)stats.getStatus().isFailed()).isTrue();
        Assertions.assertThat((boolean)snapshot.getCheckpointById(2L).getStatus().isFailed()).isTrue();
        Assertions.assertThat(it).hasNext();
        stats = (AbstractCheckpointStats)it.next();
        Assertions.assertThat((long)stats.getCheckpointId()).isOne();
        Assertions.assertThat((Object)snapshot.getCheckpointById(1L)).isNotNull();
        Assertions.assertThat((boolean)stats.getStatus().isFailed()).isTrue();
        Assertions.assertThat((boolean)snapshot.getCheckpointById(1L).getStatus().isFailed()).isTrue();
        Assertions.assertThat(it).isExhausted();
    }

    @Test
    void testModifySnapshot() throws Exception {
        CheckpointStatsHistory history = new CheckpointStatsHistory(3);
        history.addInProgressCheckpoint(this.createPendingCheckpointStats(0L));
        history.addInProgressCheckpoint(this.createPendingCheckpointStats(1L));
        history.addInProgressCheckpoint(this.createPendingCheckpointStats(2L));
        CheckpointStatsHistory snapshot = history.createSnapshot();
        try {
            snapshot.addInProgressCheckpoint(this.createPendingCheckpointStats(4L));
            Assertions.fail((String)"Did not throw expected Exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            snapshot.replacePendingCheckpointById((AbstractCheckpointStats)this.createCompletedCheckpointStats(2L));
            Assertions.fail((String)"Did not throw expected Exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            snapshot.createSnapshot();
            Assertions.fail((String)"Did not throw expected Exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private PendingCheckpointStats createPendingCheckpointStats(long checkpointId) {
        PendingCheckpointStats pending = (PendingCheckpointStats)Mockito.mock(PendingCheckpointStats.class);
        Mockito.when((Object)pending.getStatus()).thenReturn((Object)CheckpointStatsStatus.IN_PROGRESS);
        Mockito.when((Object)pending.getCheckpointId()).thenReturn((Object)checkpointId);
        Mockito.when((Object)pending.getProperties()).thenReturn((Object)CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION));
        return pending;
    }

    private CompletedCheckpointStats createCompletedCheckpointStats(long checkpointId) {
        CompletedCheckpointStats completed = (CompletedCheckpointStats)Mockito.mock(CompletedCheckpointStats.class);
        Mockito.when((Object)completed.getStatus()).thenReturn((Object)CheckpointStatsStatus.COMPLETED);
        Mockito.when((Object)completed.getProperties()).thenReturn((Object)CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION));
        Mockito.when((Object)completed.getCheckpointId()).thenReturn((Object)checkpointId);
        Mockito.when((Object)completed.getProperties()).thenReturn((Object)CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION));
        return completed;
    }

    private FailedCheckpointStats createFailedCheckpointStats(long checkpointId) {
        FailedCheckpointStats failed = (FailedCheckpointStats)Mockito.mock(FailedCheckpointStats.class);
        Mockito.when((Object)failed.getStatus()).thenReturn((Object)CheckpointStatsStatus.FAILED);
        Mockito.when((Object)failed.getProperties()).thenReturn((Object)CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION));
        Mockito.when((Object)failed.getCheckpointId()).thenReturn((Object)checkpointId);
        return failed;
    }
}

