/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Random;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.checkpoint.SavepointType;
import org.apache.flink.runtime.checkpoint.SnapshotType;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class CheckpointOptionsTest {
    CheckpointOptionsTest() {
    }

    @Test
    void testDefaultCheckpoint() throws Exception {
        CheckpointOptions options = CheckpointOptions.forCheckpointWithDefaultLocation();
        Assertions.assertThat((Object)options.getCheckpointType()).isEqualTo((Object)CheckpointType.CHECKPOINT);
        Assertions.assertThat((boolean)options.getTargetLocation().isDefaultReference()).isTrue();
        CheckpointOptions copy = (CheckpointOptions)CommonTestUtils.createCopySerializable((Serializable)options);
        Assertions.assertThat((Object)copy.getCheckpointType()).isEqualTo((Object)CheckpointType.CHECKPOINT);
        Assertions.assertThat((boolean)copy.getTargetLocation().isDefaultReference()).isTrue();
    }

    @Test
    void testSavepoint() throws Exception {
        Random rnd = new Random();
        byte[] locationBytes = new byte[rnd.nextInt(41) + 1];
        rnd.nextBytes(locationBytes);
        SnapshotType[] snapshotTypes = new SnapshotType[]{CheckpointType.CHECKPOINT, CheckpointType.FULL_CHECKPOINT, SavepointType.savepoint((SavepointFormatType)SavepointFormatType.CANONICAL), SavepointType.suspend((SavepointFormatType)SavepointFormatType.CANONICAL), SavepointType.terminate((SavepointFormatType)SavepointFormatType.CANONICAL)};
        CheckpointOptions options = new CheckpointOptions(snapshotTypes[rnd.nextInt(snapshotTypes.length)], new CheckpointStorageLocationReference(locationBytes));
        CheckpointOptions copy = (CheckpointOptions)CommonTestUtils.createCopySerializable((Serializable)options);
        Assertions.assertThat((Object)copy.getCheckpointType()).isEqualTo((Object)options.getCheckpointType());
        Assertions.assertThat((byte[])copy.getTargetLocation().getReferenceBytes()).isEqualTo((Object)locationBytes);
    }

    @Test
    void testSavepointNeedsAlignment() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> new CheckpointOptions((SnapshotType)SavepointType.savepoint((SavepointFormatType)SavepointFormatType.CANONICAL), CheckpointStorageLocationReference.getDefault(), CheckpointOptions.AlignmentType.UNALIGNED, 0L));
    }

    @Test
    void testCheckpointNeedsAlignment() {
        CheckpointStorageLocationReference location = CheckpointStorageLocationReference.getDefault();
        Assertions.assertThat((boolean)new CheckpointOptions((SnapshotType)CheckpointType.CHECKPOINT, location, CheckpointOptions.AlignmentType.UNALIGNED, Long.MAX_VALUE).needsAlignment()).isFalse();
        Assertions.assertThat((boolean)new CheckpointOptions((SnapshotType)CheckpointType.CHECKPOINT, location, CheckpointOptions.AlignmentType.ALIGNED, Long.MAX_VALUE).needsAlignment()).isTrue();
        Assertions.assertThat((boolean)new CheckpointOptions((SnapshotType)CheckpointType.CHECKPOINT, location, CheckpointOptions.AlignmentType.FORCED_ALIGNED, Long.MAX_VALUE).needsAlignment()).isTrue();
        Assertions.assertThat((boolean)new CheckpointOptions((SnapshotType)CheckpointType.CHECKPOINT, location, CheckpointOptions.AlignmentType.AT_LEAST_ONCE, Long.MAX_VALUE).needsAlignment()).isFalse();
    }

    @Test
    void testCheckpointIsTimeoutable() {
        CheckpointStorageLocationReference location = CheckpointStorageLocationReference.getDefault();
        this.assertTimeoutable(CheckpointOptions.alignedWithTimeout((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)location, (long)10L), false, true, 10L);
        this.assertTimeoutable(CheckpointOptions.unaligned((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)location), true, false, Long.MAX_VALUE);
        this.assertTimeoutable(CheckpointOptions.alignedWithTimeout((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)location, (long)10L).withUnalignedUnsupported(), false, false, 10L);
        this.assertTimeoutable(CheckpointOptions.unaligned((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)location).withUnalignedUnsupported(), false, false, Long.MAX_VALUE);
    }

    @Test
    void testForceAlignmentIsReversable() {
        CheckpointStorageLocationReference location = CheckpointStorageLocationReference.getDefault();
        this.assertReversable(CheckpointOptions.alignedWithTimeout((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)location, (long)10L), true);
        this.assertReversable(CheckpointOptions.unaligned((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)location), true);
        this.assertReversable(CheckpointOptions.alignedNoTimeout((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)location), false);
        this.assertReversable(CheckpointOptions.alignedNoTimeout((SnapshotType)SavepointType.savepoint((SavepointFormatType)SavepointFormatType.CANONICAL), (CheckpointStorageLocationReference)location), false);
        this.assertReversable(CheckpointOptions.notExactlyOnce((SnapshotType)CheckpointType.CHECKPOINT, (CheckpointStorageLocationReference)location), false);
        this.assertReversable(CheckpointOptions.notExactlyOnce((SnapshotType)SavepointType.savepoint((SavepointFormatType)SavepointFormatType.CANONICAL), (CheckpointStorageLocationReference)location), false);
    }

    private void assertReversable(CheckpointOptions options, boolean forceHasEffect) {
        ((ObjectAssert)Assertions.assertThat((Object)options.withUnalignedSupported()).as("all non-forced options support unaligned mode", new Object[0])).isEqualTo((Object)options);
        CheckpointOptions unalignedUnsupported = options.withUnalignedUnsupported();
        if (forceHasEffect) {
            ((ObjectAssert)Assertions.assertThat((Object)unalignedUnsupported).as("expected changes in the options", new Object[0])).isNotEqualTo((Object)options);
        } else {
            ((ObjectAssert)Assertions.assertThat((Object)unalignedUnsupported).as("not expected changes to the options", new Object[0])).isEqualTo((Object)options);
        }
        ((ObjectAssert)Assertions.assertThat((Object)unalignedUnsupported.withUnalignedSupported()).as("expected fully reversable options", new Object[0])).isEqualTo((Object)options);
    }

    private void assertTimeoutable(CheckpointOptions options, boolean isUnaligned, boolean isTimeoutable, long timeout) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)options.isExactlyOnceMode()).as("exactly once", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)options.needsAlignment()).as("need alignment", new Object[0])).isEqualTo(!isUnaligned);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)options.isUnalignedCheckpoint()).as("unaligned", new Object[0])).isEqualTo(isUnaligned);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)options.isTimeoutable()).as("timeoutable", new Object[0])).isEqualTo(isTimeoutable);
        ((AbstractLongAssert)Assertions.assertThat((long)options.getAlignedCheckpointTimeout()).as("timeout", new Object[0])).isEqualTo(timeout);
    }
}

