/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.Serializable;
import java.util.EnumMap;

public interface StateObject
extends Serializable {
    public void discardState() throws Exception;

    public long getStateSize();

    default public void collectSizeStats(StateObjectSizeStatsCollector collector) {
        collector.add(StateObjectLocation.UNKNOWN, this.getStateSize());
    }

    public static final class StateObjectSizeStatsCollector {
        private final EnumMap<StateObjectLocation, Long> stats = new EnumMap(StateObjectLocation.class);

        private StateObjectSizeStatsCollector() {
        }

        public void add(StateObjectLocation key, long value) {
            this.stats.compute(key, (k, v) -> {
                if (v != null) {
                    return v + value;
                }
                return value;
            });
        }

        public EnumMap<StateObjectLocation, Long> getStats() {
            return this.stats;
        }

        public static StateObjectSizeStatsCollector create() {
            return new StateObjectSizeStatsCollector();
        }

        public String toString() {
            return "StateObjectSizeStatsCollector{stats=" + String.valueOf(this.stats) + "}";
        }
    }

    public static enum StateObjectLocation {
        LOCAL_MEMORY,
        LOCAL_DISK,
        REMOTE,
        UNKNOWN;

    }
}

