/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public class SubtasksTimesInfo
implements ResponseBody {
    public static final String FIELD_NAME_ID = "id";
    public static final String FIELD_NAME_NAME = "name";
    public static final String FIELD_NAME_NOW = "now";
    public static final String FIELD_NAME_SUBTASKS = "subtasks";
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="now")
    private final long now;
    @JsonProperty(value="subtasks")
    private final List<SubtaskTimeInfo> subtasks;

    @JsonCreator
    public SubtasksTimesInfo(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="now") long now, @JsonProperty(value="subtasks") List<SubtaskTimeInfo> subtasks) {
        this.id = (String)Preconditions.checkNotNull((Object)id);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.now = now;
        this.subtasks = (List)Preconditions.checkNotNull(subtasks);
    }

    @JsonIgnore
    public String getId() {
        return this.id;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public long getNow() {
        return this.now;
    }

    @JsonIgnore
    public List<SubtaskTimeInfo> getSubtasks() {
        return this.subtasks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubtasksTimesInfo that = (SubtasksTimesInfo)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && this.now == that.now && Objects.equals(this.subtasks, that.subtasks);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.now, this.subtasks);
    }

    public static final class SubtaskTimeInfo {
        public static final String FIELD_NAME_SUBTASK = "subtask";
        public static final String FIELD_NAME_ENDPOINT = "endpoint";
        public static final String FIELD_NAME_DURATION = "duration";
        public static final String FIELD_NAME_TIMESTAMPS = "timestamps";
        @JsonProperty(value="subtask")
        private final int subtask;
        @JsonProperty(value="endpoint")
        private final String endpoint;
        @JsonProperty(value="duration")
        private final long duration;
        @JsonProperty(value="timestamps")
        private final Map<ExecutionState, Long> timestamps;

        public SubtaskTimeInfo(@JsonProperty(value="subtask") int subtask, @JsonProperty(value="endpoint") String endpoint, @JsonProperty(value="duration") long duration, @JsonProperty(value="timestamps") Map<ExecutionState, Long> timestamps) {
            this.subtask = subtask;
            this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint);
            this.duration = duration;
            this.timestamps = (Map)Preconditions.checkNotNull(timestamps);
        }

        @JsonIgnore
        public int getSubtask() {
            return this.subtask;
        }

        @JsonIgnore
        public String getEndpoint() {
            return this.endpoint;
        }

        @JsonIgnore
        public long getDuration() {
            return this.duration;
        }

        @JsonIgnore
        public Map<ExecutionState, Long> getTimestamps() {
            return this.timestamps;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o || this.getClass() != o.getClass()) {
                return false;
            }
            SubtaskTimeInfo that = (SubtaskTimeInfo)o;
            return this.subtask == that.subtask && Objects.equals(this.endpoint, that.endpoint) && this.duration == that.duration && Objects.equals(this.timestamps, that.timestamps);
        }

        public int hashCode() {
            return Objects.hash(this.subtask, this.endpoint, this.duration, this.timestamps);
        }
    }
}

