/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.profiler;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.rest.messages.ProfilingInfo;
import org.apache.flink.runtime.util.profiler.ProfilingService;
import org.apache.flink.util.StringUtils;
import org.apache.flink.util.TestLogger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.io.TempDir;

public class ProfilingServiceTest
extends TestLogger {
    private static final String NO_ACCESS_TO_PERF_EVENTS = "No access to perf events.";
    private static final String NO_ALLOC_SYMBOL_FOUND = "No AllocTracer symbols found.";
    private static final String RESOURCE_ID = "TestJobManager";
    private static final long DEFAULT_PROFILING_DURATION = 3L;
    private static final int HISTORY_SIZE_LIMIT = 2;
    private ProfilingService profilingService;
    private final Configuration configs = new Configuration();

    @BeforeEach
    void setUp(@TempDir Path tempDir) {
        this.configs.set(RestOptions.MAX_PROFILING_HISTORY_SIZE, (Object)2);
        this.configs.set(RestOptions.PROFILING_RESULT_DIR, (Object)tempDir.toString());
        this.profilingService = ProfilingService.getInstance((Configuration)this.configs);
    }

    @AfterEach
    void tearDown() throws IOException {
        this.profilingService.close();
    }

    @Test
    public void testSingleton() throws IOException {
        try (ProfilingService testService = ProfilingService.getInstance((Configuration)this.configs);){
            Assertions.assertEquals((Object)this.profilingService, (Object)testService);
        }
    }

    @Test
    void testProfilingConfigurationWorkingAsExpected() throws IOException {
        try (ProfilingService testService = ProfilingService.getInstance((Configuration)this.configs);){
            Assertions.assertEquals((Object)this.configs.get(RestOptions.PROFILING_RESULT_DIR), (Object)testService.getProfilingResultDir());
            Assertions.assertEquals((Integer)((Integer)this.configs.get(RestOptions.MAX_PROFILING_HISTORY_SIZE)), (int)testService.getHistorySizeLimit());
        }
    }

    @Test
    void testFailedRequestSinceStillUnderProfiling() throws ExecutionException, InterruptedException {
        this.requestSingleProfiling(ProfilingInfo.ProfilingMode.ITIMER, 10L, false);
        try {
            this.requestSingleProfiling(ProfilingInfo.ProfilingMode.ITIMER, 10L, false);
            Assertions.fail((String)"Duplicate profiling request should throw with IllegalStateException.");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof IllegalStateException));
        }
    }

    @Test
    @Timeout(value=1L, unit=TimeUnit.MINUTES)
    public void testAllProfilingMode() throws ExecutionException, InterruptedException {
        for (ProfilingInfo.ProfilingMode mode : ProfilingInfo.ProfilingMode.values()) {
            this.requestSingleProfiling(mode, 3L, true);
        }
    }

    @Test
    @Timeout(value=1L, unit=TimeUnit.MINUTES)
    public void testRollingDeletion() throws ExecutionException, InterruptedException {
        for (int i = 0; i < 3; ++i) {
            this.requestSingleProfiling(ProfilingInfo.ProfilingMode.ITIMER, 3L, true);
        }
        this.verifyRollingDeletionWorks();
    }

    private void requestSingleProfiling(ProfilingInfo.ProfilingMode mode, Long duration, Boolean waitUntilFinished) throws InterruptedException, ExecutionException {
        ProfilingInfo profilingInfo = (ProfilingInfo)this.profilingService.requestProfiling(RESOURCE_ID, duration.longValue(), mode).get();
        if (this.isNoPermissionOrAllocateSymbol(profilingInfo)) {
            this.log.warn("Ignoring failed profiling instance in {} mode, which caused by {}.", (Object)profilingInfo.getProfilingMode(), (Object)profilingInfo.getMessage());
            return;
        }
        Assertions.assertEquals((Object)ProfilingInfo.ProfilingStatus.RUNNING, (Object)profilingInfo.getStatus(), (String)String.format("Submitting profiling request should be started successfully or failed by no permission, but got errorMsg=%s", profilingInfo.getMessage()));
        if (waitUntilFinished.booleanValue()) {
            this.waitForProfilingFinished();
            Assertions.assertEquals((Object)ProfilingInfo.ProfilingStatus.FINISHED, (Object)profilingInfo.getStatus(), (String)String.format("Profiling request should complete successful, but got errorMsg=%s", profilingInfo.getMessage()));
        }
    }

    private void verifyRollingDeletionWorks() {
        ArrayDeque profilingList = this.profilingService.getProfilingListForTest(RESOURCE_ID);
        Assertions.assertTrue((profilingList.size() <= this.profilingService.getHistorySizeLimit() ? 1 : 0) != 0);
        HashSet<String> resultFileNames = new HashSet<String>();
        File configuredDir = new File(this.profilingService.getProfilingResultDir());
        for (File f : Objects.requireNonNull(configuredDir.listFiles())) {
            if (!f.getName().startsWith(RESOURCE_ID)) continue;
            resultFileNames.add(f.getName());
        }
        if (profilingList.size() != resultFileNames.size()) {
            this.log.error("Found unexpected profiling file size: profilingList={},resultFileNames={}", (Object)profilingList, resultFileNames);
        }
        Assertions.assertEquals((int)profilingList.size(), (int)resultFileNames.size());
        for (ProfilingInfo profilingInfo : profilingList) {
            String outputFile = profilingInfo.getOutputFile();
            Assertions.assertTrue((boolean)resultFileNames.contains(outputFile));
        }
    }

    private void waitForProfilingFinished() throws InterruptedException {
        while (!this.profilingService.getProfilingFuture().isDone()) {
            Thread.sleep(1000L);
        }
    }

    private boolean isNoPermissionOrAllocateSymbol(ProfilingInfo profilingInfo) {
        boolean isNoPermission = profilingInfo.getStatus() == ProfilingInfo.ProfilingStatus.FAILED && !StringUtils.isNullOrWhitespaceOnly((String)profilingInfo.getMessage()) && profilingInfo.getMessage().contains(NO_ACCESS_TO_PERF_EVENTS);
        boolean isNoAllocateSymbol = profilingInfo.getStatus() == ProfilingInfo.ProfilingStatus.FAILED && !StringUtils.isNullOrWhitespaceOnly((String)profilingInfo.getMessage()) && profilingInfo.getMessage().contains(NO_ALLOC_SYMBOL_FOUND);
        return isNoPermission || isNoAllocateSymbol;
    }
}

