/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.flink.core.testutils.AllCallbackWrapper;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.runtime.blocklist.BlocklistHandler;
import org.apache.flink.runtime.blocklist.NoOpBlocklistHandler;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.entrypoint.ClusterInformation;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.io.network.partition.NoOpResourceManagerPartitionTracker;
import org.apache.flink.runtime.metrics.groups.ResourceManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.resourcemanager.JobLeaderIdService;
import org.apache.flink.runtime.resourcemanager.StandaloneResourceManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingSlotManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingSlotManagerBuilder;
import org.apache.flink.runtime.resourcemanager.utils.MockResourceManagerRuntimeServices;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.rpc.TestingRpcServiceExtension;
import org.apache.flink.runtime.security.token.DelegationTokenManager;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class StandaloneResourceManagerTest {
    @RegisterExtension
    public static final AllCallbackWrapper<TestingRpcServiceExtension> RPC_SERVICE_EXTENSION_WRAPPER = new AllCallbackWrapper((CustomExtension)new TestingRpcServiceExtension());
    private static final Duration TIMEOUT = Duration.ofSeconds(10L);
    private final TestingFatalErrorHandler fatalErrorHandler = new TestingFatalErrorHandler();

    StandaloneResourceManagerTest() {
    }

    @Test
    public void testStartupPeriod() throws Exception {
        LinkedBlockingQueue setFailUnfulfillableRequestInvokes = new LinkedBlockingQueue();
        TestingSlotManager slotManager = new TestingSlotManagerBuilder().setSetFailUnfulfillableRequestConsumer(setFailUnfulfillableRequestInvokes::add).createSlotManager();
        TestingStandaloneResourceManager rm = this.createResourceManager(Duration.ofMillis(1L), slotManager);
        Assertions.assertThat((Boolean)((Boolean)setFailUnfulfillableRequestInvokes.take())).isFalse();
        Assertions.assertThat((Boolean)((Boolean)setFailUnfulfillableRequestInvokes.take())).isTrue();
        rm.close();
    }

    @Test
    public void testNoStartupPeriod() throws Exception {
        LinkedBlockingQueue setFailUnfulfillableRequestInvokes = new LinkedBlockingQueue();
        TestingSlotManager slotManager = new TestingSlotManagerBuilder().setSetFailUnfulfillableRequestConsumer(setFailUnfulfillableRequestInvokes::add).createSlotManager();
        TestingStandaloneResourceManager rm = this.createResourceManager(Duration.ofMillis(-1L), slotManager);
        Assertions.assertThat((Boolean)((Boolean)setFailUnfulfillableRequestInvokes.take())).isFalse();
        Assertions.assertThat((Boolean)((Boolean)setFailUnfulfillableRequestInvokes.poll(50L, TimeUnit.MILLISECONDS))).isNull();
        rm.close();
    }

    private TestingStandaloneResourceManager createResourceManager(Duration startupPeriod, SlotManager slotManager) throws Exception {
        MockResourceManagerRuntimeServices rmServices = new MockResourceManagerRuntimeServices(((TestingRpcServiceExtension)RPC_SERVICE_EXTENSION_WRAPPER.getCustomExtension()).getTestingRpcService(), slotManager);
        TestingStandaloneResourceManager rm = new TestingStandaloneResourceManager(rmServices.rpcService, UUID.randomUUID(), ResourceID.generate(), rmServices.heartbeatServices, rmServices.delegationTokenManager, rmServices.slotManager, rmServices.jobLeaderIdService, new ClusterInformation("localhost", 1234), this.fatalErrorHandler, UnregisteredMetricGroups.createUnregisteredResourceManagerMetricGroup(), startupPeriod);
        rm.start();
        rm.getStartedFuture().get(TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
        return rm;
    }

    private static class TestingStandaloneResourceManager
    extends StandaloneResourceManager {
        private TestingStandaloneResourceManager(RpcService rpcService, UUID leaderSessionId, ResourceID resourceId, HeartbeatServices heartbeatServices, DelegationTokenManager delegationTokenManager, SlotManager slotManager, JobLeaderIdService jobLeaderIdService, ClusterInformation clusterInformation, FatalErrorHandler fatalErrorHandler, ResourceManagerMetricGroup resourceManagerMetricGroup, Duration startupPeriodTime) {
            super(rpcService, leaderSessionId, resourceId, heartbeatServices, delegationTokenManager, slotManager, NoOpResourceManagerPartitionTracker::get, (BlocklistHandler.Factory)new NoOpBlocklistHandler.Factory(), jobLeaderIdService, clusterInformation, fatalErrorHandler, resourceManagerMetricGroup, startupPeriodTime, RpcUtils.INF_TIMEOUT, (Executor)ForkJoinPool.commonPool());
        }
    }
}

