/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.RpcTaskManagerGateway;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlot;
import org.apache.flink.runtime.jobmaster.slotpool.DefaultFreeSlotTracker;
import org.apache.flink.runtime.jobmaster.slotpool.FreeSlotTracker;
import org.apache.flink.runtime.jobmaster.slotpool.FreeSlotTrackerTestUtils;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGatewayBuilder;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultFreeSlotTrackerTest {
    DefaultFreeSlotTrackerTest() {
    }

    @Test
    void testReserveSlot() {
        ResourceID resourceId = ResourceID.generate();
        AllocatedSlot slot1 = this.createAllocatedSlot(resourceId);
        AllocatedSlot slot2 = this.createAllocatedSlot(resourceId);
        HashMap<AllocationID, PhysicalSlot> slots = new HashMap<AllocationID, PhysicalSlot>();
        slots.put(slot1.getAllocationId(), (PhysicalSlot)slot1);
        slots.put(slot2.getAllocationId(), (PhysicalSlot)slot2);
        DefaultFreeSlotTracker freeSlotTracker = FreeSlotTrackerTestUtils.createDefaultFreeSlotTracker(slots);
        Iterator iterator = freeSlotTracker.getAvailableSlots().iterator();
        if (iterator.hasNext()) {
            AllocationID candidate = (AllocationID)iterator.next();
            SlotInfo selectSlot = freeSlotTracker.getSlotInfo(candidate);
            Assertions.assertThat((Object)((PhysicalSlot)slots.get(selectSlot.getAllocationId()))).isEqualTo((Object)selectSlot);
            freeSlotTracker.reserveSlot(selectSlot.getAllocationId());
        }
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)freeSlotTracker.getAvailableSlots()).hasSize(1)).containsAnyOf((Object[])new AllocationID[]{slot1.getAllocationId(), slot2.getAllocationId()});
    }

    @Test
    void testCreatedFreeSlotTrackerWithoutBlockedSlots() {
        ResourceID resourceId = ResourceID.generate();
        AllocatedSlot slot1 = this.createAllocatedSlot(resourceId);
        AllocatedSlot slot2 = this.createAllocatedSlot(resourceId);
        HashMap<AllocationID, PhysicalSlot> slots = new HashMap<AllocationID, PhysicalSlot>();
        slots.put(slot1.getAllocationId(), (PhysicalSlot)slot1);
        slots.put(slot2.getAllocationId(), (PhysicalSlot)slot2);
        DefaultFreeSlotTracker freeSlotTracker = FreeSlotTrackerTestUtils.createDefaultFreeSlotTracker(slots);
        Assertions.assertThat((Collection)freeSlotTracker.getAvailableSlots()).hasSize(2);
        FreeSlotTracker freeSlotTrackerWithoutBlockedSlots = freeSlotTracker.createNewFreeSlotTrackerWithoutBlockedSlots(new HashSet<AllocationID>(Arrays.asList(slot1.getAllocationId(), slot2.getAllocationId())));
        Assertions.assertThat((Collection)freeSlotTrackerWithoutBlockedSlots.getAvailableSlots()).isEmpty();
    }

    private AllocatedSlot createAllocatedSlot(ResourceID owner) {
        return new AllocatedSlot(new AllocationID(), new TaskManagerLocation(owner, InetAddress.getLoopbackAddress(), 41), 0, ResourceProfile.UNKNOWN, (TaskManagerGateway)new RpcTaskManagerGateway((TaskExecutorGateway)new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway(), JobMasterId.generate()));
    }
}

