/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.scheduler.DefaultScheduler;
import org.apache.flink.runtime.scheduler.SchedulerTestingUtils;
import org.apache.flink.runtime.testtasks.NoOpInvokable;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class FinalizeOnMasterTest {
    @RegisterExtension
    static final TestExecutorExtension<ScheduledExecutorService> EXECUTOR_RESOURCE = TestingUtils.defaultExecutorExtension();

    FinalizeOnMasterTest() {
    }

    @Test
    void testFinalizeIsCalledUponSuccess() throws Exception {
        JobVertex vertex1 = (JobVertex)Mockito.spy((Object)new JobVertex("test vertex 1"));
        vertex1.setInvokableClass(NoOpInvokable.class);
        vertex1.setParallelism(3);
        JobVertex vertex2 = (JobVertex)Mockito.spy((Object)new JobVertex("test vertex 2"));
        vertex2.setInvokableClass(NoOpInvokable.class);
        vertex2.setParallelism(2);
        DefaultScheduler scheduler = SchedulerTestingUtils.createScheduler(JobGraphTestUtils.streamingJobGraph(vertex1, vertex2), ComponentMainThreadExecutorServiceAdapter.forMainThread(), (ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor());
        scheduler.startScheduling();
        ExecutionGraph eg = scheduler.getExecutionGraph();
        Assertions.assertThat((Comparable)eg.getState()).isEqualTo((Object)JobStatus.RUNNING);
        ExecutionGraphTestUtils.switchAllVerticesToRunning(eg);
        ExecutionGraphTestUtils.finishAllVertices(eg);
        Assertions.assertThat((Comparable)eg.waitUntilTerminal()).isEqualTo((Object)JobStatus.FINISHED);
        ((JobVertex)Mockito.verify((Object)vertex1, (VerificationMode)Mockito.times((int)1))).finalizeOnMaster((JobVertex.FinalizeOnMasterContext)Mockito.any(JobVertex.FinalizeOnMasterContext.class));
        ((JobVertex)Mockito.verify((Object)vertex2, (VerificationMode)Mockito.times((int)1))).finalizeOnMaster((JobVertex.FinalizeOnMasterContext)Mockito.any(JobVertex.FinalizeOnMasterContext.class));
        Assertions.assertThat((Map)eg.getRegisteredExecutions()).isEmpty();
    }

    @Test
    void testFinalizeIsNotCalledUponFailure() throws Exception {
        JobVertex vertex = (JobVertex)Mockito.spy((Object)new JobVertex("test vertex 1"));
        vertex.setInvokableClass(NoOpInvokable.class);
        vertex.setParallelism(1);
        DefaultScheduler scheduler = SchedulerTestingUtils.createScheduler(JobGraphTestUtils.streamingJobGraph(vertex), ComponentMainThreadExecutorServiceAdapter.forMainThread(), (ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor());
        scheduler.startScheduling();
        ExecutionGraph eg = scheduler.getExecutionGraph();
        Assertions.assertThat((Comparable)eg.getState()).isEqualTo((Object)JobStatus.RUNNING);
        ExecutionGraphTestUtils.switchAllVerticesToRunning(eg);
        Execution exec = eg.getJobVertex(vertex.getID()).getTaskVertices()[0].getCurrentExecutionAttempt();
        exec.fail((Throwable)new Exception("test"));
        Assertions.assertThat((Comparable)eg.waitUntilTerminal()).isEqualTo((Object)JobStatus.FAILED);
        ((JobVertex)Mockito.verify((Object)vertex, (VerificationMode)Mockito.times((int)0))).finalizeOnMaster((JobVertex.FinalizeOnMasterContext)Mockito.any(JobVertex.FinalizeOnMasterContext.class));
        Assertions.assertThat((Map)eg.getRegisteredExecutions()).isEmpty();
    }
}

