/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.scheduler.ExecutionSlotSharingGroup;
import org.apache.flink.runtime.scheduler.SchedulingTopologyListener;
import org.apache.flink.runtime.scheduler.SlotSharingStrategy;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.util.Preconditions;

abstract class AbstractSlotSharingStrategy
implements SlotSharingStrategy,
SchedulingTopologyListener {
    protected final Map<ExecutionVertexID, ExecutionSlotSharingGroup> executionSlotSharingGroupMap;
    protected final Set<SlotSharingGroup> logicalSlotSharingGroups;
    protected final Set<CoLocationGroup> coLocationGroups;

    AbstractSlotSharingStrategy(SchedulingTopology topology, Set<SlotSharingGroup> slotSharingGroups, Set<CoLocationGroup> coLocationGroups) {
        this.logicalSlotSharingGroups = (Set)Preconditions.checkNotNull(slotSharingGroups);
        this.coLocationGroups = (Set)Preconditions.checkNotNull(coLocationGroups);
        this.executionSlotSharingGroupMap = this.computeExecutionSlotSharingGroups(topology);
        topology.registerSchedulingTopologyListener(this);
    }

    @Override
    public ExecutionSlotSharingGroup getExecutionSlotSharingGroup(ExecutionVertexID executionVertexId) {
        return this.executionSlotSharingGroupMap.get(executionVertexId);
    }

    @Override
    public Set<ExecutionSlotSharingGroup> getExecutionSlotSharingGroups() {
        return new HashSet<ExecutionSlotSharingGroup>(this.executionSlotSharingGroupMap.values());
    }

    @Override
    public void notifySchedulingTopologyUpdated(SchedulingTopology schedulingTopology, List<ExecutionVertexID> newExecutionVertices) {
        Map<ExecutionVertexID, ExecutionSlotSharingGroup> newMap = this.computeExecutionSlotSharingGroups(schedulingTopology);
        for (ExecutionVertexID vertexId : newMap.keySet()) {
            ExecutionSlotSharingGroup newEssg = newMap.get(vertexId);
            ExecutionSlotSharingGroup oldEssg = this.executionSlotSharingGroupMap.get(vertexId);
            if (oldEssg == null) {
                this.executionSlotSharingGroupMap.put(vertexId, newEssg);
                continue;
            }
            Preconditions.checkState((boolean)oldEssg.getExecutionVertexIds().equals(newEssg.getExecutionVertexIds()), (Object)"Existing ExecutionSlotSharingGroups are changed after topology update");
        }
    }

    @Nonnull
    static LinkedHashMap<JobVertexID, List<SchedulingExecutionVertex>> getExecutionVertices(SchedulingTopology topology) {
        LinkedHashMap<JobVertexID, List<SchedulingExecutionVertex>> vertices = new LinkedHashMap<JobVertexID, List<SchedulingExecutionVertex>>();
        for (SchedulingExecutionVertex executionVertex : topology.getVertices()) {
            List executionVertexGroup = vertices.computeIfAbsent(((ExecutionVertexID)executionVertex.getId()).getJobVertexId(), k -> new ArrayList());
            executionVertexGroup.add(executionVertex);
        }
        return vertices;
    }

    protected abstract Map<ExecutionVertexID, ExecutionSlotSharingGroup> computeExecutionSlotSharingGroups(SchedulingTopology var1);
}

