/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.source;

import org.apache.flink.streaming.api.operators.source.CollectingDataOutput;
import org.apache.flink.streaming.api.operators.source.WatermarkToDataOutput;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class WatermarkToDataOutputTest {
    WatermarkToDataOutputTest() {
    }

    @Test
    void testInitialZeroWatermark() {
        CollectingDataOutput testingOutput = new CollectingDataOutput();
        WatermarkToDataOutput wmOutput = new WatermarkToDataOutput(testingOutput);
        wmOutput.emitWatermark(new org.apache.flink.api.common.eventtime.Watermark(0L));
        Assertions.assertThat(testingOutput.events).contains(new Object[]{new Watermark(0L)});
    }

    @Test
    void testWatermarksDoNotRegress() {
        CollectingDataOutput testingOutput = new CollectingDataOutput();
        WatermarkToDataOutput wmOutput = new WatermarkToDataOutput(testingOutput);
        wmOutput.emitWatermark(new org.apache.flink.api.common.eventtime.Watermark(12L));
        wmOutput.emitWatermark(new org.apache.flink.api.common.eventtime.Watermark(17L));
        wmOutput.emitWatermark(new org.apache.flink.api.common.eventtime.Watermark(10L));
        wmOutput.emitWatermark(new org.apache.flink.api.common.eventtime.Watermark(18L));
        wmOutput.emitWatermark(new org.apache.flink.api.common.eventtime.Watermark(17L));
        wmOutput.emitWatermark(new org.apache.flink.api.common.eventtime.Watermark(18L));
        Assertions.assertThat(testingOutput.events).contains(new Object[]{new Watermark(12L), new Watermark(17L), new Watermark(18L)});
    }

    @Test
    void becomingActiveEmitsStatus() {
        CollectingDataOutput testingOutput = new CollectingDataOutput();
        WatermarkToDataOutput wmOutput = new WatermarkToDataOutput(testingOutput);
        wmOutput.markIdle();
        wmOutput.emitWatermark(new org.apache.flink.api.common.eventtime.Watermark(100L));
        Assertions.assertThat(testingOutput.events).contains(new Object[]{WatermarkStatus.IDLE, WatermarkStatus.ACTIVE, new Watermark(100L)});
    }
}

