/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.state.CheckpointStateOutputStream;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.IOUtils;

public class BlockingCheckpointOutputStream
extends CheckpointStateOutputStream {
    private final FSDataOutputStream delegate;
    private final OneShotLatch triggerUnblock;
    private final OneShotLatch waitForBlocking;
    private final AtomicBoolean closed;
    private final long blockAtPosition;
    private long position;

    public BlockingCheckpointOutputStream(@Nullable OneShotLatch waitForBlocking, @Nullable OneShotLatch triggerUnblock) {
        this(null, waitForBlocking, triggerUnblock, 0L);
    }

    public BlockingCheckpointOutputStream(@Nullable FSDataOutputStream delegate, @Nullable OneShotLatch waitForBlock, @Nullable OneShotLatch triggerUnblock) {
        this(delegate, waitForBlock, triggerUnblock, 0L);
    }

    public BlockingCheckpointOutputStream(@Nullable FSDataOutputStream delegate, @Nullable OneShotLatch waitForBlocking, @Nullable OneShotLatch triggerUnblock, long blockAtPosition) {
        this.delegate = delegate;
        this.triggerUnblock = triggerUnblock;
        this.waitForBlocking = waitForBlocking;
        this.blockAtPosition = blockAtPosition;
        if (delegate != null) {
            try {
                this.position = delegate.getPos();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.position = 0L;
        }
        this.closed = new AtomicBoolean(false);
    }

    public void write(int b) throws IOException {
        if (this.position == this.blockAtPosition) {
            this.unblockWaiter();
            this.awaitUnblocker();
        }
        if (this.delegate != null) {
            try {
                this.delegate.write(b);
            }
            catch (IOException ex) {
                this.unblockWaiter();
                throw ex;
            }
        }
        if (this.closed.get()) {
            throw new IOException("Stream closed.");
        }
        ++this.position;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    public long getPos() throws IOException {
        return this.position;
    }

    public void flush() throws IOException {
        if (this.delegate != null) {
            this.delegate.flush();
        }
    }

    public void sync() throws IOException {
        if (this.delegate != null) {
            this.delegate.sync();
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.delegate != null) {
                IOUtils.closeQuietly((AutoCloseable)this.delegate);
            }
            this.unblockAll();
        }
    }

    private void unblockWaiter() {
        if (null != this.waitForBlocking) {
            this.waitForBlocking.trigger();
        }
    }

    private void awaitUnblocker() {
        if (null != this.triggerUnblock) {
            try {
                this.triggerUnblock.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void unblockAll() {
        if (null != this.waitForBlocking) {
            this.waitForBlocking.trigger();
        }
        if (null != this.triggerUnblock) {
            this.triggerUnblock.trigger();
        }
    }

    @Nullable
    public StreamStateHandle closeAndGetHandle() throws IOException {
        if (!this.closed.compareAndSet(false, true)) {
            throw new IOException("Stream was already closed!");
        }
        if (this.delegate instanceof CheckpointStateOutputStream) {
            StreamStateHandle streamStateHandle = ((CheckpointStateOutputStream)this.delegate).closeAndGetHandle();
            this.unblockAll();
            return streamStateHandle;
        }
        this.unblockAll();
        throw new IOException("Delegate is not a CheckpointStateOutputStream!");
    }

    public boolean isClosed() {
        return this.closed.get();
    }
}

