/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl.mock;

import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.internal.InternalReducingState;
import org.apache.flink.runtime.state.ttl.mock.MockInternalMergingState;

class MockInternalReducingState<K, N, T>
extends MockInternalMergingState<K, N, T, T, T>
implements InternalReducingState<K, N, T> {
    private final ReduceFunction<T> reduceFunction;

    private MockInternalReducingState(ReduceFunction<T> reduceFunction) {
        this.reduceFunction = reduceFunction;
    }

    public T get() {
        return this.getInternal();
    }

    public void add(T value) throws Exception {
        this.updateInternal(this.reduceFunction.reduce(this.get(), value));
    }

    @Override
    T mergeState(T t, T nAcc) throws Exception {
        return (T)this.reduceFunction.reduce(t, nAcc);
    }

    static <N, T, S extends State, IS extends S> IS createState(TypeSerializer<N> namespaceSerializer, StateDescriptor<S, T> stateDesc) {
        ReducingStateDescriptor reducingStateDesc = (ReducingStateDescriptor)stateDesc;
        return (IS)new MockInternalReducingState(reducingStateDesc.getReduceFunction());
    }
}

