/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.internal.InternalMergingState;
import org.apache.flink.runtime.state.ttl.TtlStateTestContextBase;

abstract class TtlMergingStateTestContext<S extends InternalMergingState<?, String, ?, ?, GV>, UV, GV>
extends TtlStateTestContextBase<S, UV, GV> {
    static final Random RANDOM = new Random();
    static final List<String> NAMESPACES = Arrays.asList("unsetNamespace1", "unsetNamespace2", "expiredNamespace", "expiredAndUpdatedNamespace", "unexpiredNamespace", "finalNamespace");

    TtlMergingStateTestContext() {
    }

    List<Tuple2<String, UV>> generateExpiredUpdatesToMerge() {
        return Arrays.asList(Tuple2.of((Object)"expiredNamespace", this.generateRandomUpdate()), Tuple2.of((Object)"expiredNamespace", this.generateRandomUpdate()), Tuple2.of((Object)"expiredAndUpdatedNamespace", this.generateRandomUpdate()), Tuple2.of((Object)"expiredAndUpdatedNamespace", this.generateRandomUpdate()));
    }

    List<Tuple2<String, UV>> generateUnexpiredUpdatesToMerge() {
        return Arrays.asList(Tuple2.of((Object)"expiredAndUpdatedNamespace", this.generateRandomUpdate()), Tuple2.of((Object)"expiredAndUpdatedNamespace", this.generateRandomUpdate()), Tuple2.of((Object)"unexpiredNamespace", this.generateRandomUpdate()), Tuple2.of((Object)"unexpiredNamespace", this.generateRandomUpdate()));
    }

    List<Tuple2<String, UV>> generateFinalUpdatesToMerge() {
        return Arrays.asList(Tuple2.of((Object)"expiredAndUpdatedNamespace", this.generateRandomUpdate()), Tuple2.of((Object)"expiredAndUpdatedNamespace", this.generateRandomUpdate()), Tuple2.of((Object)"unexpiredNamespace", this.generateRandomUpdate()), Tuple2.of((Object)"unexpiredNamespace", this.generateRandomUpdate()), Tuple2.of((Object)"finalNamespace", this.generateRandomUpdate()), Tuple2.of((Object)"finalNamespace", this.generateRandomUpdate()));
    }

    abstract UV generateRandomUpdate();

    void applyStateUpdates(List<Tuple2<String, UV>> updates) throws Exception {
        for (Tuple2<String, UV> t : updates) {
            ((InternalMergingState)this.ttlState).setCurrentNamespace((Object)((String)t.f0));
            this.update(t.f1);
        }
    }

    abstract GV getMergeResult(List<Tuple2<String, UV>> var1, List<Tuple2<String, UV>> var2);

    static abstract class TtlIntegerMergingStateTestContext<S extends InternalMergingState<?, String, ?, ?, GV>, UV extends Number, GV>
    extends TtlMergingStateTestContext<S, UV, GV> {
        TtlIntegerMergingStateTestContext() {
        }

        @Override
        UV generateRandomUpdate() {
            return (UV)Integer.valueOf(RANDOM.nextInt(1000));
        }

        int getIntegerMergeResult(List<Tuple2<String, UV>> unexpiredUpdatesToMerge, List<Tuple2<String, UV>> finalUpdatesToMerge) {
            return unexpiredUpdatesToMerge.stream().mapToInt(t -> (Integer)t.f1).sum() + finalUpdatesToMerge.stream().mapToInt(t -> (Integer)t.f1).sum();
        }
    }
}

