/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.router;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.rest.handler.router.RouteResult;
import org.apache.flink.runtime.rest.handler.router.Router;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMethod;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class RouterTest {
    private Router<String> router;

    RouterTest() {
    }

    @BeforeEach
    public void setUp() {
        this.router = StringRouter.create();
    }

    @Test
    void testIgnoreSlashesAtBothEnds() {
        Assertions.assertThat((String)((String)this.router.route(HttpMethod.GET, "articles").target())).isEqualTo("index");
        Assertions.assertThat((String)((String)this.router.route(HttpMethod.GET, "/articles").target())).isEqualTo("index");
        Assertions.assertThat((String)((String)this.router.route(HttpMethod.GET, "//articles").target())).isEqualTo("index");
        Assertions.assertThat((String)((String)this.router.route(HttpMethod.GET, "articles/").target())).isEqualTo("index");
        Assertions.assertThat((String)((String)this.router.route(HttpMethod.GET, "articles//").target())).isEqualTo("index");
        Assertions.assertThat((String)((String)this.router.route(HttpMethod.GET, "/articles/").target())).isEqualTo("index");
        Assertions.assertThat((String)((String)this.router.route(HttpMethod.GET, "//articles//").target())).isEqualTo("index");
    }

    @Test
    void testEmptyParams() {
        RouteResult routed = this.router.route(HttpMethod.GET, "/articles");
        Assertions.assertThat((String)((String)routed.target())).isEqualTo("index");
        Assertions.assertThat((Map)routed.pathParams()).isEmpty();
    }

    @Test
    void testParams() {
        RouteResult routed = this.router.route(HttpMethod.GET, "/articles/123");
        Assertions.assertThat((String)((String)routed.target())).isEqualTo("show");
        Assertions.assertThat((Map)routed.pathParams()).hasSize(1);
        Assertions.assertThat((String)((String)routed.pathParams().get("id"))).isEqualTo("123");
    }

    @Test
    void testNone() {
        RouteResult routed = this.router.route(HttpMethod.GET, "/noexist");
        Assertions.assertThat((String)((String)routed.target())).isEqualTo("404");
    }

    @Test
    void testSplatWildcard() {
        RouteResult routed = this.router.route(HttpMethod.GET, "/download/foo/bar.png");
        Assertions.assertThat((String)((String)routed.target())).isEqualTo("download");
        Assertions.assertThat((Map)routed.pathParams()).hasSize(1);
        Assertions.assertThat((String)((String)routed.pathParams().get("*"))).isEqualTo("foo/bar.png");
    }

    @Test
    void testOrder() {
        RouteResult routed1 = this.router.route(HttpMethod.GET, "/articles/new");
        Assertions.assertThat((String)((String)routed1.target())).isEqualTo("new");
        Assertions.assertThat((Map)routed1.pathParams()).isEmpty();
        RouteResult routed2 = this.router.route(HttpMethod.GET, "/articles/123");
        Assertions.assertThat((String)((String)routed2.target())).isEqualTo("show");
        Assertions.assertThat((Map)routed2.pathParams()).hasSize(1);
        Assertions.assertThat((String)((String)routed2.pathParams().get("id"))).isEqualTo("123");
        RouteResult routed3 = this.router.route(HttpMethod.GET, "/notfound");
        Assertions.assertThat((String)((String)routed3.target())).isEqualTo("404");
        Assertions.assertThat((Map)routed3.pathParams()).isEmpty();
        RouteResult routed4 = this.router.route(HttpMethod.GET, "/articles/overview");
        Assertions.assertThat((String)((String)routed4.target())).isEqualTo("overview");
        Assertions.assertThat((Map)routed4.pathParams()).isEmpty();
        RouteResult routed5 = this.router.route(HttpMethod.GET, "/articles/overview/detailed");
        Assertions.assertThat((String)((String)routed5.target())).isEqualTo("detailed");
        Assertions.assertThat((Map)routed5.pathParams()).isEmpty();
    }

    @Test
    void testAnyMethod() {
        RouteResult routed1 = this.router.route(HttpMethod.GET, "/anyMethod");
        Assertions.assertThat((String)((String)routed1.target())).isEqualTo("anyMethod");
        Assertions.assertThat((Map)routed1.pathParams()).isEmpty();
        RouteResult routed2 = this.router.route(HttpMethod.POST, "/anyMethod");
        Assertions.assertThat((String)((String)routed2.target())).isEqualTo("anyMethod");
        Assertions.assertThat((Map)routed2.pathParams()).isEmpty();
    }

    @Test
    void testRemoveByPathPattern() {
        this.router.removePathPattern("/articles");
        RouteResult routed = this.router.route(HttpMethod.GET, "/articles");
        Assertions.assertThat((String)((String)routed.target())).isEqualTo("404");
    }

    @Test
    void testAllowedMethods() {
        Assertions.assertThat((Collection)this.router.allAllowedMethods()).hasSize(9);
        Set methods = this.router.allowedMethods("/articles");
        Assertions.assertThat((Collection)methods).hasSize(2);
        Assertions.assertThat((boolean)methods.contains(HttpMethod.GET)).isTrue();
        Assertions.assertThat((boolean)methods.contains(HttpMethod.POST)).isTrue();
    }

    @Test
    void testSubclasses() {
        Router router = new Router().addRoute(HttpMethod.GET, "/articles", Index.class).addRoute(HttpMethod.GET, "/articles/:id", Show.class);
        RouteResult routed1 = router.route(HttpMethod.GET, "/articles");
        RouteResult routed2 = router.route(HttpMethod.GET, "/articles/123");
        Assertions.assertThat((Object)routed1).isNotNull();
        Assertions.assertThat((Object)routed2).isNotNull();
        Assertions.assertThat((Class)((Class)routed1.target())).isEqualTo(Index.class);
        Assertions.assertThat((Class)((Class)routed2.target())).isEqualTo(Show.class);
    }

    private class Show
    implements Action {
        private Show() {
        }
    }

    private class Index
    implements Action {
        private Index() {
        }
    }

    private static interface Action {
    }

    private static final class StringRouter {
        private StringRouter() {
        }

        static Router<String> create() {
            return new Router().addGet("/articles", (Object)"index").addGet("/articles/new", (Object)"new").addGet("/articles/overview", (Object)"overview").addGet("/articles/overview/detailed", (Object)"detailed").addGet("/articles/:id", (Object)"show").addGet("/articles/:id/:format", (Object)"show").addPost("/articles", (Object)"post").addPatch("/articles/:id", (Object)"patch").addDelete("/articles/:id", (Object)"delete").addAny("/anyMethod", (Object)"anyMethod").addGet("/download/:*", (Object)"download").notFound((Object)"404");
        }
    }
}

