/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.PendingRequest;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.RequestSlotMatchingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SimpleRequestSlotMatchingStrategy;
import org.apache.flink.runtime.scheduler.TestingPhysicalSlot;
import org.apache.flink.shaded.guava32.com.google.common.collect.Iterators;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={TestLoggerExtension.class})
public class SimpleRequestSlotMatchingStrategyTest {
    @Test
    public void testSlotRequestsAreMatchedInOrder() {
        SimpleRequestSlotMatchingStrategy simpleRequestSlotMatchingStrategy = SimpleRequestSlotMatchingStrategy.INSTANCE;
        List<PhysicalSlot> slots = Arrays.asList(TestingPhysicalSlot.builder().build());
        PendingRequest pendingRequest1 = PendingRequest.createNormalRequest((SlotRequestId)new SlotRequestId(), (ResourceProfile)ResourceProfile.UNKNOWN, Collections.emptyList());
        PendingRequest pendingRequest2 = PendingRequest.createNormalRequest((SlotRequestId)new SlotRequestId(), (ResourceProfile)ResourceProfile.UNKNOWN, Collections.emptyList());
        List<PendingRequest> pendingRequests = Arrays.asList(pendingRequest1, pendingRequest2);
        Collection requestSlotMatches = simpleRequestSlotMatchingStrategy.matchRequestsAndSlots(slots, pendingRequests);
        Assertions.assertThat((Collection)requestSlotMatches).hasSize(1);
        Assertions.assertThat((Comparable)((RequestSlotMatchingStrategy.RequestSlotMatch)Iterators.getOnlyElement(requestSlotMatches.iterator())).getPendingRequest().getSlotRequestId()).isEqualTo((Object)pendingRequest1.getSlotRequestId());
    }

    @Test
    public void testSlotRequestsThatCanBeFulfilledAreMatched() {
        SimpleRequestSlotMatchingStrategy simpleRequestSlotMatchingStrategy = SimpleRequestSlotMatchingStrategy.INSTANCE;
        ResourceProfile small = ResourceProfile.newBuilder().setCpuCores(1.0).build();
        ResourceProfile large = ResourceProfile.newBuilder().setCpuCores(2.0).build();
        List<PhysicalSlot> slots = Arrays.asList(TestingPhysicalSlot.builder().withResourceProfile(small).build(), TestingPhysicalSlot.builder().withResourceProfile(small).build());
        PendingRequest pendingRequest1 = PendingRequest.createNormalRequest((SlotRequestId)new SlotRequestId(), (ResourceProfile)large, Collections.emptyList());
        PendingRequest pendingRequest2 = PendingRequest.createNormalRequest((SlotRequestId)new SlotRequestId(), (ResourceProfile)small, Collections.emptyList());
        List<PendingRequest> pendingRequests = Arrays.asList(pendingRequest1, pendingRequest2);
        Collection requestSlotMatches = simpleRequestSlotMatchingStrategy.matchRequestsAndSlots(slots, pendingRequests);
        Assertions.assertThat((Collection)requestSlotMatches).hasSize(1);
        Assertions.assertThat((Comparable)((RequestSlotMatchingStrategy.RequestSlotMatch)Iterators.getOnlyElement(requestSlotMatches.iterator())).getPendingRequest().getSlotRequestId()).isEqualTo((Object)pendingRequest2.getSlotRequestId());
    }
}

