/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobMasterService;
import org.apache.flink.runtime.jobmaster.utils.TestingJobMasterGatewayBuilder;
import org.apache.flink.util.Preconditions;

public class TestingJobMasterService
implements JobMasterService {
    @Nonnull
    private final String address;
    private final JobMasterGateway jobMasterGateway;
    private final CompletableFuture<Void> terminationFuture;
    private final boolean completeTerminationFutureOnCloseAsync;

    public TestingJobMasterService(@Nonnull String address, @Nullable CompletableFuture<Void> terminationFuture, @Nullable JobMasterGateway gateway) {
        this.address = address;
        this.jobMasterGateway = gateway == null ? new TestingJobMasterGatewayBuilder().build() : gateway;
        if (terminationFuture == null) {
            this.terminationFuture = new CompletableFuture();
            this.completeTerminationFutureOnCloseAsync = true;
        } else {
            this.terminationFuture = terminationFuture;
            this.completeTerminationFutureOnCloseAsync = false;
        }
    }

    public TestingJobMasterService(JobMasterGateway gateway) {
        this("localhost", null, gateway);
    }

    public TestingJobMasterService() {
        this("localhost", null, null);
    }

    public JobMasterGateway getGateway() {
        Preconditions.checkNotNull((Object)this.jobMasterGateway, (String)"TestingJobMasterService has not been started yet.");
        return this.jobMasterGateway;
    }

    public String getAddress() {
        return this.address;
    }

    public CompletableFuture<Void> getTerminationFuture() {
        return this.terminationFuture;
    }

    public CompletableFuture<Void> closeAsync() {
        if (this.completeTerminationFutureOnCloseAsync) {
            this.terminationFuture.complete(null);
        }
        return this.terminationFuture;
    }

    public boolean isClosed() {
        return this.terminationFuture.isDone();
    }
}

