/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.compression;

import java.nio.ByteBuffer;
import java.util.stream.Stream;
import org.apache.flink.configuration.NettyShuffleEnvironmentOptions;
import org.apache.flink.runtime.io.compression.BlockCompressionFactory;
import org.apache.flink.runtime.io.compression.BlockCompressor;
import org.apache.flink.runtime.io.compression.BlockDecompressor;
import org.apache.flink.runtime.io.compression.BufferCompressionException;
import org.apache.flink.runtime.io.compression.BufferDecompressionException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class BlockCompressionTest {
    BlockCompressionTest() {
    }

    private static Stream<BlockCompressionFactory> compressCodecGenerator() {
        return Stream.of(BlockCompressionFactory.createBlockCompressionFactory((NettyShuffleEnvironmentOptions.CompressionCodec)NettyShuffleEnvironmentOptions.CompressionCodec.LZ4), BlockCompressionFactory.createBlockCompressionFactory((NettyShuffleEnvironmentOptions.CompressionCodec)NettyShuffleEnvironmentOptions.CompressionCodec.LZO), BlockCompressionFactory.createBlockCompressionFactory((NettyShuffleEnvironmentOptions.CompressionCodec)NettyShuffleEnvironmentOptions.CompressionCodec.ZSTD));
    }

    @ParameterizedTest
    @MethodSource(value={"compressCodecGenerator"})
    void testBlockCompression(BlockCompressionFactory factory) {
        this.runArrayTest(factory, 32768);
        this.runArrayTest(factory, 16);
        this.runByteBufferTest(factory, false, 32768);
        this.runByteBufferTest(factory, false, 16);
        this.runByteBufferTest(factory, true, 32768);
        this.runByteBufferTest(factory, true, 16);
    }

    private void runArrayTest(BlockCompressionFactory factory, int originalLen) {
        BlockCompressor compressor = factory.getCompressor();
        BlockDecompressor decompressor = factory.getDecompressor();
        int originalOff = 64;
        byte[] data = new byte[originalOff + originalLen];
        for (int i = 0; i < originalLen; ++i) {
            data[originalOff + i] = (byte)i;
        }
        int compressedOff = 32;
        byte[] insufficientCompressArray = new byte[compressedOff + 8 + 1];
        Assertions.assertThatThrownBy(() -> compressor.compress(data, originalOff, originalLen, insufficientCompressArray, compressedOff)).isInstanceOf(BufferCompressionException.class);
        byte[] compressedData = new byte[compressedOff + compressor.getMaxCompressedSize(originalLen)];
        int compressedLen = compressor.compress(data, originalOff, originalLen, compressedData, compressedOff);
        int decompressedOff = 16;
        byte[] insufficientDecompressArray = new byte[decompressedOff + originalLen - 1];
        Assertions.assertThatThrownBy(() -> decompressor.decompress(compressedData, compressedOff, compressedLen, insufficientDecompressArray, decompressedOff)).isInstanceOf(BufferDecompressionException.class);
        byte[] decompressedData = new byte[decompressedOff + originalLen];
        int decompressedLen = decompressor.decompress(compressedData, compressedOff, compressedLen, decompressedData, decompressedOff);
        Assertions.assertThat((int)decompressedLen).isEqualTo(originalLen);
        for (int i = 0; i < originalLen; ++i) {
            Assertions.assertThat((byte)decompressedData[decompressedOff + i]).isEqualTo(data[originalOff + i]);
        }
    }

    private void runByteBufferTest(BlockCompressionFactory factory, boolean isDirect, int originalLen) {
        int i;
        BlockCompressor compressor = factory.getCompressor();
        BlockDecompressor decompressor = factory.getDecompressor();
        int originalOff = 64;
        ByteBuffer data = isDirect ? ByteBuffer.allocateDirect(originalOff + originalLen) : ByteBuffer.allocate(originalOff + originalLen);
        for (i = 0; i < originalOff; ++i) {
            data.put((byte)90);
        }
        for (i = 0; i < originalLen; ++i) {
            data.put((byte)i);
        }
        data.flip();
        int maxCompressedLen = compressor.getMaxCompressedSize(originalLen);
        ByteBuffer compressedData = isDirect ? ByteBuffer.allocateDirect(maxCompressedLen) : ByteBuffer.allocate(maxCompressedLen);
        int compressedLen = compressor.compress(data, originalOff, originalLen, compressedData, 0);
        Assertions.assertThat((int)compressedData.position()).isEqualTo(compressedLen);
        compressedData.flip();
        int compressedOff = 32;
        ByteBuffer copiedCompressedData = isDirect ? ByteBuffer.allocateDirect(compressedOff + compressedLen) : ByteBuffer.allocate(compressedOff + compressedLen);
        for (int i2 = 0; i2 < compressedOff; ++i2) {
            copiedCompressedData.put((byte)90);
        }
        byte[] compressedByteArray = new byte[compressedLen];
        compressedData.get(compressedByteArray, 0, compressedLen);
        copiedCompressedData.put(compressedByteArray);
        copiedCompressedData.flip();
        ByteBuffer decompressedData = isDirect ? ByteBuffer.allocateDirect(originalLen) : ByteBuffer.allocate(originalLen);
        int decompressedLen = decompressor.decompress(copiedCompressedData, compressedOff, compressedLen, decompressedData, 0);
        Assertions.assertThat((int)decompressedData.position()).isEqualTo(decompressedLen);
        decompressedData.flip();
        for (int i3 = 0; i3 < decompressedLen; ++i3) {
            Assertions.assertThat((byte)decompressedData.get()).isEqualTo((byte)i3);
        }
    }
}

