/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.nonha.embedded;

import java.util.UUID;
import junit.framework.TestCase;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedHaServices;
import org.apache.flink.runtime.highavailability.nonha.embedded.TestingLeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElection;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.util.LeaderRetrievalUtils;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.Executors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class EmbeddedHaServicesTest
extends TestLogger {
    private static final String ADDRESS = "foobar";
    private EmbeddedHaServices embeddedHaServices;

    @Before
    public void setupTest() {
        this.embeddedHaServices = new EmbeddedHaServices(Executors.directExecutor());
    }

    @After
    public void teardownTest() throws Exception {
        if (this.embeddedHaServices != null) {
            this.embeddedHaServices.closeWithOptionalClean(true);
            this.embeddedHaServices = null;
        }
    }

    @Test
    public void testJobManagerLeaderElection() throws Exception {
        JobID jobId1 = new JobID();
        JobID jobId2 = new JobID();
        LeaderContender leaderContender1 = (LeaderContender)Mockito.mock(LeaderContender.class);
        LeaderContender leaderContender2 = (LeaderContender)Mockito.mock(LeaderContender.class);
        LeaderContender leaderContenderDifferentJobId = (LeaderContender)Mockito.mock(LeaderContender.class);
        LeaderElection leaderElection1 = this.embeddedHaServices.getJobManagerLeaderElection(jobId1);
        leaderElection1.startLeaderElection(leaderContender1);
        LeaderElection leaderElection2 = this.embeddedHaServices.getJobManagerLeaderElection(jobId1);
        leaderElection2.startLeaderElection(leaderContender2);
        LeaderElection leaderElectionDifferentJobId = this.embeddedHaServices.getJobManagerLeaderElection(jobId2);
        leaderElectionDifferentJobId.startLeaderElection(leaderContenderDifferentJobId);
        ArgumentCaptor leaderIdArgumentCaptor1 = ArgumentCaptor.forClass(UUID.class);
        ArgumentCaptor leaderIdArgumentCaptor2 = ArgumentCaptor.forClass(UUID.class);
        ((LeaderContender)Mockito.verify((Object)leaderContender1, (VerificationMode)Mockito.atLeast((int)0))).grantLeadership((UUID)leaderIdArgumentCaptor1.capture());
        ((LeaderContender)Mockito.verify((Object)leaderContender2, (VerificationMode)Mockito.atLeast((int)0))).grantLeadership((UUID)leaderIdArgumentCaptor2.capture());
        TestCase.assertTrue((boolean)(leaderIdArgumentCaptor1.getAllValues().isEmpty() ^ leaderIdArgumentCaptor2.getAllValues().isEmpty()));
        ((LeaderContender)Mockito.verify((Object)leaderContenderDifferentJobId)).grantLeadership((UUID)ArgumentMatchers.any(UUID.class));
    }

    @Test
    public void testResourceManagerLeaderElection() throws Exception {
        LeaderContender leaderContender1 = (LeaderContender)Mockito.mock(LeaderContender.class);
        LeaderContender leaderContender2 = (LeaderContender)Mockito.mock(LeaderContender.class);
        LeaderElection leaderElection1 = this.embeddedHaServices.getResourceManagerLeaderElection();
        leaderElection1.startLeaderElection(leaderContender1);
        LeaderElection leaderElection2 = this.embeddedHaServices.getResourceManagerLeaderElection();
        leaderElection2.startLeaderElection(leaderContender2);
        ArgumentCaptor leaderIdArgumentCaptor1 = ArgumentCaptor.forClass(UUID.class);
        ArgumentCaptor leaderIdArgumentCaptor2 = ArgumentCaptor.forClass(UUID.class);
        ((LeaderContender)Mockito.verify((Object)leaderContender1, (VerificationMode)Mockito.atLeast((int)0))).grantLeadership((UUID)leaderIdArgumentCaptor1.capture());
        ((LeaderContender)Mockito.verify((Object)leaderContender2, (VerificationMode)Mockito.atLeast((int)0))).grantLeadership((UUID)leaderIdArgumentCaptor2.capture());
        TestCase.assertTrue((boolean)(leaderIdArgumentCaptor1.getAllValues().isEmpty() ^ leaderIdArgumentCaptor2.getAllValues().isEmpty()));
    }

    @Test
    public void testJobManagerLeaderRetrieval() throws Exception {
        JobID jobId = new JobID();
        LeaderElection leaderElection = this.embeddedHaServices.getJobManagerLeaderElection(jobId);
        LeaderRetrievalService leaderRetrievalService = this.embeddedHaServices.getJobManagerLeaderRetriever(jobId);
        this.runLeaderRetrievalTest(leaderElection, leaderRetrievalService);
    }

    private void runLeaderRetrievalTest(LeaderElection leaderElection, LeaderRetrievalService leaderRetrievalService) throws Exception {
        LeaderRetrievalUtils.LeaderInformationListener leaderRetrievalListener = new LeaderRetrievalUtils.LeaderInformationListener();
        TestingLeaderContender leaderContender = new TestingLeaderContender();
        leaderRetrievalService.start((LeaderRetrievalListener)leaderRetrievalListener);
        leaderElection.startLeaderElection((LeaderContender)leaderContender);
        UUID leaderId = leaderContender.getLeaderSessionFuture().get();
        leaderElection.confirmLeadershipAsync(leaderId, ADDRESS).get();
        LeaderInformation leaderInformation = (LeaderInformation)leaderRetrievalListener.getLeaderInformationFuture().get();
        Assert.assertThat((Object)leaderInformation.getLeaderAddress(), (Matcher)Matchers.is((Object)ADDRESS));
        Assert.assertThat((Object)leaderInformation.getLeaderSessionID(), (Matcher)Matchers.is((Object)leaderId));
    }

    @Test
    public void testResourceManagerLeaderRetrieval() throws Exception {
        LeaderElection leaderElection = this.embeddedHaServices.getResourceManagerLeaderElection();
        LeaderRetrievalService leaderRetrievalService = this.embeddedHaServices.getResourceManagerLeaderRetriever();
        this.runLeaderRetrievalTest(leaderElection, leaderRetrievalService);
    }

    @Test
    public void testConcurrentLeadershipOperations() throws Exception {
        LeaderElection leaderElection = this.embeddedHaServices.getDispatcherLeaderElection();
        TestingLeaderContender leaderContender = new TestingLeaderContender();
        leaderElection.startLeaderElection((LeaderContender)leaderContender);
        UUID oldLeaderSessionId = leaderContender.getLeaderSessionFuture().get();
        Assert.assertThat((Object)((Boolean)leaderElection.hasLeadershipAsync(oldLeaderSessionId).get()), (Matcher)Matchers.is((Object)true));
        this.embeddedHaServices.getDispatcherLeaderService().revokeLeadership().get();
        Assert.assertThat((Object)((Boolean)leaderElection.hasLeadershipAsync(oldLeaderSessionId).get()), (Matcher)Matchers.is((Object)false));
        this.embeddedHaServices.getDispatcherLeaderService().grantLeadership();
        UUID newLeaderSessionId = leaderContender.getLeaderSessionFuture().get();
        Assert.assertThat((Object)((Boolean)leaderElection.hasLeadershipAsync(newLeaderSessionId).get()), (Matcher)Matchers.is((Object)true));
        leaderElection.confirmLeadershipAsync(oldLeaderSessionId, ADDRESS).get();
        leaderElection.confirmLeadershipAsync(newLeaderSessionId, ADDRESS).get();
        Assert.assertThat((Object)((Boolean)leaderElection.hasLeadershipAsync(newLeaderSessionId).get()), (Matcher)Matchers.is((Object)true));
        leaderContender.tryRethrowException();
    }
}

